package bayen.nut;
import robocode.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;
import java.awt.Graphics2D;

class FieldPoint extends Point2D.Double{
	public FieldPoint(){}
	public FieldPoint(double x, double y){
		super(x,y);
	}
	
	public double absoluteAngleTo(FieldPoint p){
		double angle = Math.atan2(p.x - x, p.y - y);
		while(angle < 0.0){
		 	angle += 2.0 * Math.PI;
		}
		while(angle >= 2.0 * Math.PI){
		 	angle -= 2.0 * Math.PI;
		}
		return angle;
	}
	
	public FieldPoint project(double angle, double distance) {
		return new FieldPoint(x + Math.sin(angle) * distance, y + Math.cos(angle) * distance);
	}
}