package kawigi.robot;
import robocode.*;
import java.util.*;
import java.awt.Color;
import java.awt.geom.*;

/**
 * Girl - a robot extending Robot by Kawigi.  How does it feel to be beaten by a girl?
 **/
public class Girl extends Robot
{
	Point2D myLocation, last;
	EnemyInfo currentTarget;
	HashMap enemies = new HashMap();
	static HashMap stats = new HashMap();
	static int hits;
	double cdir = 1;
	double lastpower = 3;
	
	public void run()
	{
		//How does it feel being beaten by a girl with girly colors?
		setColors(new Color(240, 128, 240),new Color(150, 150, 255),Color.pink);
		Point2D next = null;
		Rectangle2D fieldRect = new Rectangle2D.Double(20, 20, getBattleFieldWidth()-40, getBattleFieldHeight()-40);
		do
		{
			myLocation = new Point2D.Double(getX(), getY());
			if (currentTarget == null || getOthers() > 1)
				turnRadarRight(360);
			else
			{
				double radarTurn = Math.toDegrees(robocode.util.Utils.normalRelativeAngle(angle(currentTarget, myLocation)-Math.toRadians(getRadarHeading())));
				radarTurn = (int)(radarTurn/45+(radarTurn > 0 ? 1 : -1))*45;
				currentTarget = null;
				turnRadarRight(radarTurn);
				if (currentTarget == null)
				{
					turnRadarRight(radarTurn < 0 ? -360-radarTurn : 360-radarTurn);
				}
			}
			if (currentTarget != null)
			{
				if (getOthers() > 1)
				{
					double distance = Math.max(200, myLocation.distance(currentTarget));
					double energy = currentTarget.energy;
					if (next == null)
						next = last = myLocation;
					for (int i=0; i<200; i++)
					{
						Point2D p;
						if (fieldRect.contains(p = projectPoint(myLocation, Math.random()*Math.PI*2, (getOthers() == 1 ? .5 : .5)*distance*Math.random())) && findRisk(p) < findRisk(next))
							next = p;
					}
				}
				else
				{
					double distance = Math.max(250, currentTarget.distance(myLocation))*Math.random()*8/(20-lastpower*3);
					if ((hits > 3 && Math.random() < .85) || !fieldRect.contains(projectPoint(myLocation, angle(currentTarget, myLocation)+Math.PI/3*cdir, distance)))
						cdir = -cdir;
					
					double direction = angle(currentTarget, myLocation) + Math.PI/2*cdir;
					while (!fieldRect.contains(next = projectPoint(myLocation, direction, distance)))
						direction -= cdir*.1;
				}
				//this helps the whole movement system know what direction I'm going, and avoid head-on targeting:
				last = myLocation;
				double movedir = myLocation.distance(next);
				double turn = robocode.util.Utils.normalRelativeAngle(angle(next, myLocation)-Math.toRadians(getHeading()));
				if (Math.abs(turn) > Math.PI/2)
				{
					turn = robocode.util.Utils.normalRelativeAngle(Math.PI+turn);
					movedir = -movedir;
				}
				turnRight(Math.toDegrees(turn));
				//other people have done this by setting the max velocity to 0 or 8.  This seems to be 7 bytes smaller:
				ahead(movedir);
			}
		}
		while(true);
	}
	
	private double findRisk(Point2D point)
	{
		double risk = 0;
		Iterator it = enemies.values().iterator();
		while (it.hasNext())
		{
			EnemyInfo e = (EnemyInfo)it.next();
			//start with an anti-gravity-type value:
			double thisrisk = (e.energy+50)/point.distanceSq(e);
			//woah, nested iterations!  Here, I'm counting the enemies that are closer to e than the proposed point is.
			//The more, the better, since this robot would be less likely to target me.
			int closer = 0;
			Iterator it2 = enemies.values().iterator();
			do
			{
				EnemyInfo e2 = (EnemyInfo)it2.next();
				if (e != e2 && e.distance(e2)*.9 > e.distance(point))
					closer++;
			}
			while (it2.hasNext());
			//try this, multiply this number by the number of enemies to which I would be the closest:
			//if they are likely targeting me, multiply by some factor that has to do with "perpendicularity"
			//(I think I remember David Alves calling it that):
			if (closer <= 1 || e.lastHit > getTime()-200 || e == currentTarget)
			{
				//I had to think about this one, but I think DuelistMicroMelee helped me make sure that it was correct.  I can't remember anymore.
				thisrisk *= 1+Math.abs(Math.cos(angle(myLocation, point) - angle(e, myLocation)));
			}
			//don't run into people!  (This is a guess of whether someone is between me and p)
			//I suppose this deserves an explanation.  I'm figuring that if to 36x36 squares will hit each other moving
			//along a certain vector (my vector, and I assume they'll be in roughly the same place), then a line
			//representing the vector will intersect a 72x72 square centered in the same place.
			if (new Line2D.Double(myLocation, point).intersects(new Rectangle2D.Double(e.x-36, e.y-36, 72, 72)))
				thisrisk *= 4;
			risk += thisrisk;
		}
		//if (getOthers() > 0)
			//add a small antigravity value to the point I was at before now, just to kind of push me in straight lines:
			risk += Math.random()/last.distanceSq(point);			
			//and repel my current location, to make it more likely that I change my mind before I get to my assigned
			//point (and less likely to change my mind right away maybe):
			risk += Math.random()/myLocation.distanceSq(point);
		
		return risk;
	}
	
	public void onRobotDeath(RobotDeathEvent e)
	{
		if (enemies.remove(e.getName()) == currentTarget)
			currentTarget = null;
	}
	
	public void onHitByBullet(HitByBulletEvent e)
	{
		hits++;
		double lastpower = e.getPower();
		EnemyInfo enemy;
		if ((enemy = (EnemyInfo)enemies.get(e.getName())) != null)
			enemy.lastHit = getTime();
	}
	
	public void onScannedRobot(ScannedRobotEvent e)
	{
		String name;
		EnemyInfo enemy = (EnemyInfo)enemies.get(name = e.getName());
		if (enemy == null)
			enemies.put(name, enemy = new EnemyInfo());Point2D loc;
		//wasn't making my enemies Point2D objects a good idea?
		double absBearing, distance;
		enemy.setLocation(loc = projectPoint(myLocation, absBearing = Math.toRadians(getHeading()+e.getBearing()), distance = e.getDistance()));
		if (currentTarget == null || (distance < myLocation.distance(currentTarget) && getGunHeat() > .4))
			currentTarget = enemy;
		
		int[][][][] currentStats = (int[][][][])stats.get(name);
		if (currentStats == null)
			stats.put(name, currentStats = new int[2][3][13][31]);
		
		double latd = e.getHeadingRadians()-absBearing;
		double bulletv;
		double power;
		//w00t - classic minibot code!
		int[] current = currentStats[Math.max(0, Math.min(getOthers()-1, 1))][getOthers() == 1 ? (int)(Math.abs(Math.sin(latd)*e.getVelocity()/3)) : (int)(Math.cos(latd)*e.getVelocity()/Math.abs(e.getVelocity())*1.4+1.4)][(int)(distance/(bulletv = 20-3*(power = Math.min(3, Math.max(150/distance, Math.min(getEnergy(), e.getEnergy())/4))))/10)];
		//problem with this code is that it will default to 1 if the velocity is zero, instead of defaulting the last observed value:
		double direction = (((Math.sin(latd)*e.getVelocity())< 0) ? -1 : 1)*Math.asin(8/bulletv);
		
		Vector waves = enemy.waves;
		MeleeBullet wave;
		waves.add(wave = new MeleeBullet());
		wave.startPoint = new Point2D.Double(getX(), getY());
		//wave.startPoint = myLocation;	//this is slightly inaccurate...
		wave.startgunheading = absBearing;
		wave.direction = direction;
		wave.lastPoint = loc;
		wave.bulletspeed = bulletv;
		wave.lasttime = getTime()-1;
		wave.segment = current;
		for (int i=0; i<waves.size(); i++)
		{
			if (((MeleeBullet)waves.elementAt(i)).updateEnemy(loc, getTime()))
			{
				waves.removeElementAt(i);
				i--;
			}
		}
		
		if (enemy == currentTarget)
		{
			int bestindex = 15;
			int i=30;
			if ((enemy.energy = e.getEnergy()) > 0)
				do
				{
					if (current[i] > current[bestindex])
						bestindex = i;
					i--;
				}
				while (i >= 0);
			if(getGunHeat() < .2)
			{
				turnGunRight(Math.toDegrees(robocode.util.Utils.normalRelativeAngle(absBearing-Math.toRadians(getGunHeading()) + direction*(bestindex/15.0-1))));
				fire(power);
			}
		}
	}
	
	//utility functions, I figure anyone making a goto bot has something like these, and they
	//come in useful in a lot of other random places, too:
	private static Point2D projectPoint(Point2D startPoint, double theta, double dist)
	{
		return new Point2D.Double(startPoint.getX() + dist * Math.sin(theta), startPoint.getY() + dist * Math.cos(theta));
	}
	
	//This strange habit of putting point2 before point1 in this method - and the funny thing is I think
	//I've seen other people do the same thing:
	public static double angle(Point2D point2, Point2D point1)
	{
		return Math.atan2(point2.getX()-point1.getX(), point2.getY()-point1.getY());
	}
}
