package ph.musketeer;
import robocode.*;
import robocode.util.*;
import java.util.*;
import java.awt.geom.*;
import java.awt.Color;
import ph.musketeer.util;

public class Musketeer extends AdvancedRobot {
    static final double MAX_VELOCITY = 8;
    static final double WALL_MARGIN = 25;
    static final double REVERSE_TUNER = 0.421075;
    static final double WALL_BOUNCE_TUNER = 0.699484;
    
    static StatsManager smanager;
    
    static {
        smanager = new StatsManager();
    }
    
    double firePower=1.9;
    Point2D robotLocation;
    Point2D enemyLocation;
    
    int enemyDirection;
    
    double enemyAbsoluteBearing;
    double enemyDistance;
    double enemyEnergy;
    double enemyFirePower;
    double enemyHeading;
    double enemyVelocity;
    double enemyAcceleration;
    double movementLateralAngle = 0.2;
    long accelerationTimer;
    long directionTimer;
    
    // distance, velocity, acceleration, acceleration timer, direction timer, wall index, guess factors
    static int[][][][][][][] guessFactors=new int[6][3][3][4][4][3][27];
    
    public void run() {
        setColors(Color.red, Color.red, Color.white);
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
        
        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);
    }
    
    public void onScannedRobot(ScannedRobotEvent e) {
        enemyAcceleration=Math.abs(e.getVelocity())-Math.abs(enemyVelocity);
        double enemyEnergyLost = enemyEnergy - e.getEnergy();
        enemyEnergy = e.getEnergy();
        if (enemyEnergyLost >= 0.1 && enemyEnergyLost <= 3.0) {
            enemyFirePower = enemyEnergyLost;
        }
        enemyHeading=e.getHeadingRadians();
        enemyLocation = util.vectorToLocation((enemyAbsoluteBearing= getHeadingRadians() + e.getBearingRadians()), (enemyDistance=e.getDistance()), (robotLocation= new Point2D.Double(getX(), getY())));
        if(enemyVelocity != (enemyVelocity=e.getVelocity())) accelerationTimer=getTime();
        if (enemyVelocity != 0) {
            int newEnemyDirection = Math.sin(e.getHeadingRadians()-enemyAbsoluteBearing)*enemyVelocity < 0 ? -1 : 1;
            if(newEnemyDirection != enemyDirection) directionTimer = getTime();
            enemyDirection = newEnemyDirection;
        }
        
        firePower = util.firePower(getEnergy(), enemyEnergy, enemyDistance);
        smanager.distanceHit(enemyDistance);
        int[] stats=smanager.getShootArray(this);
        int bestindex = (stats.length-1)/2;	//initialize it to be in the middle, guessfactor 0.
        for (int i=0; i<stats.length; i++)
            if (stats[bestindex] < stats[i])
                bestindex = i;
        
        setTurnGunRightRadians(Utils.normalRelativeAngle((util.absoluteBearing(robotLocation,enemyLocation)+((double)enemyDirection*((double)((2d*(double)bestindex)/((double)stats.length-1d))-1d)*util.maxEscapeAngle(firePower)))-getGunHeadingRadians()));
        setFire(firePower);
        
        addCustomEvent(new Wave(smanager.getStatsArray(this)));
        
        Point2D robotDestination = null;
        double tries = 0;
        double baseDistance = Math.max(enemyDistance, 80);
        do {
            robotDestination = util.vectorToLocation(util.absoluteBearing(enemyLocation, robotLocation) + movementLateralAngle,
            baseDistance * (1.1 - tries++ / 100.0), enemyLocation);
        } while (tries < 100 && !util.fieldRectangle(getBattleFieldWidth(), getBattleFieldHeight(), WALL_MARGIN).contains(robotDestination));
        double angle = Utils.normalRelativeAngle(util.absoluteBearing(robotLocation, robotDestination) - getHeadingRadians());
        double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(robotLocation.distance(robotDestination) * (angle == turnAngle ? 1 : -1));
        // Hit the brake pedal hard if we need to turn sharply
        setMaxVelocity(Math.abs(getTurnRemaining()) > 33 ? 0 : MAX_VELOCITY);
        
        if(Math.random() < (util.getBulletSpeed(enemyFirePower) / REVERSE_TUNER) / enemyDistance
        || tries > (enemyDistance / util.getBulletSpeed(enemyFirePower) / WALL_BOUNCE_TUNER)) {
            movementLateralAngle *= -1;
        }
        
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);
    }
    
    private class Wave extends Condition {
        protected Point2D launchLocation;
        protected long launchTime;
        protected double heading;
        protected double direction;
        protected double power;
        protected int[] returnSegment;
        
        public Wave(int[] returnSegment) {
            launchLocation=robotLocation;
            launchTime=getTime();
            this.heading=enemyAbsoluteBearing;
            this.direction=enemyDirection;
            this.returnSegment = returnSegment;
            power = firePower;
        }
        
        public boolean test() {
            //if the distance from the wave origin to our enemy has passed the distance the bullet would have traveled...
            if (launchLocation.distance(enemyLocation) <= (getTime()-launchTime)*util.getBulletSpeed(power)) {
                if(enemyEnergy>0) {
                    returnSegment[(int)Math.round(((returnSegment.length-1)*((Math.max(-1, Math.min(1, (Utils.normalRelativeAngle(util.absoluteBearing(launchLocation,enemyLocation)-heading))/util.maxEscapeAngle(power)))*direction)+1))/2)]++;
                }
                removeCustomEvent(this);
            }
            return false;
        }
        
    }
    
}