package Noran;
import robocode.*;
import java.io.*;
import java.awt.geom.*;
import java.awt.Color;
import java.util.*;
import Noran.AGravEngine;
import Noran.GravPoint;

/**
 *  by NoranRadOfZenLa
 * 
 * 
 * 
 */


public class RandomTargeting extends AdvancedRobot
{
	
	int wob,dir = 1;	
	int count, ct;
	public double BFC_X,BFC_Y,MaxX,MaxY,MinX,MinY,bearing2enemy,n_heading,scanTime,enemyvalue,fx,fy;
	int shootangle= 5;
	String T;
	Random rand = new Random();
	public AGravEngine gravity = new AGravEngine();
	public GravPoint pp = new GravPoint();


		
	public void run()
	{
	
		BFC_X = (getBattleFieldWidth()/2);
		BFC_Y = (getBattleFieldHeight()/2);
		MaxX = getBattleFieldWidth()*7/8;
		MaxY = getBattleFieldHeight()*7/8;
		MinX = getBattleFieldWidth()/8;
		MinY = getBattleFieldHeight()/8;
		setAdjustRadarForGunTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);	
		setColors(Color.cyan,Color.white,Color.white);
		setMaxVelocity(8);
		initGravEngine();
		turnRadarRight(360);


		

		while (true)
		{
		
		radar();		
		move(getX()+fx,getY()+fy,1);
		execute();
						
		}
	
	}
	
	public void onBulletHit(BulletHitEvent event)
	{
		System.out.println(shootangle);
		count = 0;
	}

	public void onWin(WinEvent event)
	{
		stop();
		gravity.reset();
		while(true)
		{
			setTurnRadarRight(20);
			setTurnGunLeft(10);
			turnRight(10);
			fire(.1);
		}
	}
	
	public void onBulletMissed(BulletMissedEvent event)
	{
		count++;
		if(count>=10)
		{
			count = 0;
			shootangle+=5;
		}
		if(shootangle>=70) shootangle = 5;
    }

	public void initGravEngine()
	{
		gravity = new AGravEngine(getBattleFieldWidth(),getBattleFieldHeight());
		gravity.reset();
		gravity.setPointDropoff(0.4);
		gravity.setWallForce(BFC_X*2);
		gravity.setWallDropoff(0.4);
		if(getOthers()>2) gravity.addPoint(new GravPoint(BFC_X,BFC_Y,200));
		gravity.addPoint(new GravPoint(0,0,200));
		gravity.addPoint(new GravPoint(0,getBattleFieldHeight(),200));
		gravity.addPoint(new GravPoint(getBattleFieldWidth(),getBattleFieldHeight(),200));
		gravity.addPoint(new GravPoint(getBattleFieldWidth(),0,200));
	}
	
	public void runGravEngine()
	{
		gravity.update(getX(),getY(),getTime());
		fx=gravity.getXForce();
		fy=gravity.getYForce();
	}
	
	public void onRobotDeath(RobotDeathEvent event)
	{
		if(event.getName()==T) T = null;
	}
	
	/*public void HitToKill(double XXX, double YYY)
	{
		double angle = (NRA(Math.toDegrees(Math.atan2((XXX-getX()),(YYY-getY()))) - getHeading()));
		if((angle>90))
		{
			turnRight(90-angle);   
			back(distance(getX(),getY(),XXX,YYY));
			return;
		}
		
		if((angle<-90))
		{
			turnLeft(angle+90);   
			back(distance(getX(),getY(),XXX,YYY));
			return;
		}

		turnRight(angle);		
		ahead(distance(getX(),getY(),XXX,YYY));
	}				*/
		
	public void onScannedRobot(ScannedRobotEvent e)
	{
		if(e.getEnergy()<=0.1)
		{
			
			gravity.addPoint(
					new GravPoint(
								( getX()+sin( e.getBearing()+getHeading() )*e.getDistance() ),
								( getY()+cos( getHeading()+e.getBearing() )*e.getDistance() ),
								-500,getTime(),15
							  	 )
						);
			
			return;
		}
		
		scanTime=getTime();
		enemyvalue =( (1/e.getDistance())*BFC_X*(BFC_X/100)+e.getEnergy()+20);
		
		gravity.addPoint(
					new GravPoint(
								( getX()+sin( e.getBearing()+getHeading() )*e.getDistance() ),
								( getY()+cos( getHeading()+e.getBearing() )*e.getDistance() ),
								enemyvalue,getTime(),5
							  	 )
						);
		
		runGravEngine();	
		
		if( (T == null) || (T == e.getName()) )
		{	
			T = e.getName();
			bearing2enemy=e.getBearing()+getHeading();
			gun(getEnergy(), e.getEnergy(), e.getVelocity());
		}
	}
	
	public void gun(double e, double ee, double vel)
	{		
		if(e>40)
		{
			if(vel<=1)
			{
				setTurnGunRight(NRA(bearing2enemy-getGunHeading()));
				setFire(1.1);
			}
			else
			{
				setTurnGunRight(NRA(bearing2enemy-getGunHeading()+(rand.nextInt(shootangle)*dir)));
				dir*=-1;	
				setFire(0.1);
			}
		}
		else
		{
			if(vel<=1)
			{
				setTurnGunRight(NRA(bearing2enemy-getGunHeading()));
				setFire(0.5);
			}
			else
			{
				if(ee<e)
				{
					setTurnGunRight(NRA(bearing2enemy-getGunHeading()+(rand.nextInt(shootangle)*dir)));
					dir*=-1;	
					setFire(0.1);
				}
			}
		}
	}
	
	public void radar()
	{
		if(getOthers()<2)
		{
			if(getTime()>scanTime+50)
			{
				setTurnRadarRight(45);
			}
			else
			{
				setTurnRadarRight(NRA(bearing2enemy-getRadarHeading()+(wob*20)));
				wob*=-1;
			}
		}
		else
		{
			setTurnRadarRight(1344342);
		}
	}

	public void onHitByBullet(HitByBulletEvent event)
	{
		gravity.addPoint( new GravPoint( getX()+2, getY(), 100,getTime(),50  ) );
	}
	
	public void onHitWall(HitWallEvent event)
	{
		gravity.addPoint( new GravPoint( getX()+2, getY(), 100, getTime()+20, 0 ) );
	}
	
	public void onHitRobot(HitRobotEvent event)
	{
		
	}
	
 	public void onDeath(DeathEvent e)
	{
		gravity.reset();	
	}
		
	public double NRA(double angle)
	{
		if (angle > -180 && angle <= 180) return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180) fixedAngle += 360;
		while (fixedAngle > 180) fixedAngle -= 360;
		return fixedAngle;
	}
	
	public void move(double XX, double YY, double multi)
	{
		double angle = (NRA(Math.toDegrees(Math.atan2((XX-getX()),(YY-getY()))) - getHeading()));
		

		if((angle>90))
		{
			setTurnRight(90-angle);   
			setBack(distance(getX(),getY(),XX,YY)*multi);
			return;
		}
		
		if((angle<-90))
		{
			setTurnLeft(angle+90);   
			setBack(distance(getX(),getY(),XX,YY)*multi);
			return;
		}

		setTurnRight(angle);		
		setAhead(distance(getX(),getY(),XX,YY)*multi);
	}
				
	public static double sin(double angle)
	{
		return Math.sin(Math.toRadians(angle));
	}
	
	public static double cos(double angle)
	{
		return Math.cos(Math.toRadians(angle));
	}

	public double distance(double x, double y, double _x, double _y)
	{
		return (Math.sqrt(Math.pow((_x-x),2) + Math.pow((_y-y),2)));
	}
}														