/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.Consts;
import emp.Enemy;
import emp.My;
import emp.Strategy;
import emp.Yngwie;
import java.util.Vector;
import robocode.ScannedRobotEvent;

public class EnemyCollection
implements Consts {
    private Yngwie yngwie;
    private long ScoresRecalculated;
    public Vector Enemies;

    public EnemyCollection(Yngwie y) {
        this.yngwie = y;
        this.Enemies = new Vector(10, 5);
        this.ScoresRecalculated = -1L;
    }

    public void printStrategies() {
        Enemy en = (Enemy)this.Enemies.elementAt(0);
        double[] Scores = new double[en.Strategies.size()];
        double[] Fired = new double[en.Strategies.size()];
        double[] Successes = new double[en.Strategies.size()];
        double[] IDs = new double[en.Strategies.size()];
        for (int j = 0; j < en.Strategies.size(); ++j) {
            IDs[j] = ((Strategy)en.Strategies.elementAt((int)j)).ID;
        }
        for (int i = 0; i < this.Enemies.size(); ++i) {
            en = (Enemy)this.Enemies.elementAt(i);
            for (int j = 0; j < en.Strategies.size(); ++j) {
                Strategy strat = (Strategy)en.Strategies.elementAt(j);
                for (int k = 0; k < en.Strategies.size(); ++k) {
                    if (IDs[k] != (double)strat.ID) continue;
                    int n = k;
                    Scores[n] = Scores[n] + strat.Score;
                    int n2 = k;
                    Fired[n2] = Fired[n2] + (double)strat.Fired;
                    int n3 = k;
                    Successes[n3] = Successes[n3] + (double)strat.successes;
                }
            }
        }
        en = (Enemy)this.Enemies.elementAt(0);
    }

    public void EnemyDeath(String Name) {
        int index = this.IndexOf(Name);
        if (index > -1) {
            Enemy en = (Enemy)this.Enemies.elementAt(index);
            en.Death = true;
            en.Scanned = true;
        }
    }

    public void ResetDeaths() {
        this.ScoresRecalculated = -1L;
        for (int i = 0; i < this.Enemies.size(); ++i) {
            ((Enemy)this.Enemies.elementAt(i)).Clear();
        }
    }

    private double InterpolateVelocity(Enemy en, int start, int last) {
        double Dist = My.Distance(en.Records[start - 1][1], en.Records[start - 1][2], en.Records[last][1], en.Records[last][2]);
        double Turns = last - start + 1;
        double vel = Dist / Turns;
        double nextvel = en.Records[last + 1][3];
        if (My.absADiffDeg(My.AngleFromTo(en.Records[start - 1][1], en.Records[start - 1][2], en.Records[last][1], en.Records[last][2]), en.Records[last][4]) / 15.0 > Turns) {
            vel *= -1.0;
        }
        vel = nextvel >= 0.0 ? (vel >= nextvel ? Math.min(vel, nextvel + 2.0) : Math.max(vel, nextvel - 1.0)) : (vel >= nextvel ? Math.min(vel, nextvel + 1.0) : Math.max(vel, nextvel - 2.0));
        if (vel > 8.0) {
            vel = 8.0;
        } else if (vel < -8.0) {
            vel = -8.0;
        }
        return vel;
    }

    private void Interpolate(Enemy en, int start, int last) {
        double Turned;
        double Turns = (double)(last - start) + 1.0;
        en.Records[last][5] = Turned = My.ADiffDeg(en.Records[start - 1][4], en.Records[last][4]) / Turns;
        for (int i = last - 1; i >= start; --i) {
            en.Records[i][0] = en.Records[i + 1][0] - 1.0;
            en.Records[i][1] = en.Records[i + 1][1] - en.Records[i + 1][3] * My.sinDeg(en.Records[i + 1][4]);
            en.Records[i][2] = en.Records[i + 1][2] - en.Records[i + 1][3] * My.cosDeg(en.Records[i + 1][4]);
            en.Records[i][7] = en.Records[i + 1][7];
            en.Records[i][4] = My.AddDegrees(en.Records[i + 1][4], -Turned);
            en.Records[i][5] = Turned;
            en.Records[i][3] = this.InterpolateVelocity(en, start, i);
            en.Records[i][6] = My.abs(en.Records[i][3]);
        }
    }

    public void StoreScanEvent(ScannedRobotEvent e) {
        Enemy en;
        int i = this.IndexOf(e.getName());
        if (i == -1) {
            en = new Enemy(e.getName());
            this.Enemies.add(0, en);
            i = 0;
        } else {
            en = (Enemy)this.Enemies.elementAt(i);
        }
        int Start = en.RC;
        int Last = en.Time() == (long)-1 || en.Time() + (long)1 + (long)8 < this.yngwie.getTime() ? Start : (int)((long)Start + this.yngwie.getTime() - en.Time() - (long)1);
        if (Last + 1 >= en.Records.length) {
            en.IncreaseRecord();
        }
        en.Records[Last][0] = this.yngwie.getTime();
        en.Records[Last][1] = this.yngwie.getX() + e.getDistance() * Math.sin(Math.toRadians(e.getBearing() + this.yngwie.getHeading()));
        en.Records[Last][2] = this.yngwie.getY() + e.getDistance() * Math.cos(Math.toRadians(e.getBearing() + this.yngwie.getHeading()));
        en.Records[Last][3] = e.getVelocity();
        en.Records[Last][4] = e.getHeading();
        en.Records[Last][7] = e.getEnergy();
        en.Records[Last][6] = My.abs(e.getVelocity());
        double firePower = 0.0;
        if (Start > 0) {
            if (this.yngwie.getTime() >= Yngwie.PeaceTime) {
                firePower = en.Energy() + en.EnergyAdjust - e.getEnergy();
            }
        }
        if (firePower >= 0.09 && firePower <= 3.0 && this.yngwie.getTime() - en.LastTimeFired > (long)4) {
            en.Records[Last][8] = firePower;
            en.LastTimeFired = this.yngwie.getTime();
        } else {
            en.Records[Last][8] = 0.0;
        }
        if (Last == 0) {
            en.Records[Last][5] = 0.0;
        } else if (en.Records[Last][0] == en.Records[Last - 1][0] + 1.0) {
            en.Records[Last][5] = My.ADiffDeg(en.Records[Last - 1][4], en.Records[Last][4]);
        }
        if (Start != Last) {
            this.Interpolate(en, Start, Last);
        }
        en.EnergyAdjust = 0.0;
        en.RC = Last + 1;
        en.Scanned = true;
    }

    public int IndexOf(String EnemyName) {
        for (int i = 0; i < this.Enemies.size(); ++i) {
            if (((Enemy)this.Enemies.elementAt((int)i)).Death || ((Enemy)this.Enemies.elementAt((int)i)).Name != EnemyName) continue;
            return i;
        }
        return -1;
    }

    private void CalcEnemyTargetScore(Enemy en) {
        double score = 0.0;
        if (!en.Death && en.Time() != (long)-1) {
            if (en == this.yngwie.gunner.Target) {
                score += Math.max(50.0, 10.0 * (15.0 - (double)this.yngwie.GetCoolingDownTurns()));
            }
            score -= Math.max(200.0, (double)(this.yngwie.getTime() - en.Time()));
            double dist = this.yngwie.Distance(en);
            score += 1200.0 - this.yngwie.Distance(en);
            score += Math.max(0.0, 600.0 - 2.0 * dist);
            score += 1.5 * (100.0 - en.Energy());
            score += My.sqr(Math.max(0.0, 15.0 - en.Energy()));
            if (en.Energy() <= 0.1) {
                score += 100.0;
            }
            score += 4.0 * en.BulletDamage;
            score += Math.max(0.0, 200.0 - 2.0 * (double)(this.yngwie.getTime() - en.LastTimeHitMe));
            score = Math.max(0.0, score);
        }
        en.TargetScore = score;
    }

    public Enemy getBestEnemy() {
        Enemy result = null;
        double MaxScore = 0.0;
        for (int i = 0; i < this.Enemies.size(); ++i) {
            double Score;
            Enemy en = (Enemy)this.Enemies.elementAt(i);
            if (this.ScoresRecalculated != this.yngwie.getTime()) {
                this.CalcEnemyTargetScore(en);
            }
            if (!((Score = en.TargetScore) > MaxScore)) continue;
            MaxScore = Score;
            result = en;
        }
        this.ScoresRecalculated = this.yngwie.getTime();
        return result;
    }
}

