/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotHistory;
import pedersen.debug.Debug;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;

public abstract class SnapshotHistoryBase
implements SnapshotHistory {
    public static final int snapshotHistorySize = 3;
    private Snapshot[] snapshot = new Snapshot[3];

    public void appendSnapshot(Snapshot newSnapshot) {
        int i = 3;
        while (i > 1) {
            this.snapshot[i - 1] = this.snapshot[i - 2];
            --i;
        }
        this.snapshot[0] = newSnapshot;
    }

    public Snapshot getHistoricalSnapshot(int index) {
        Snapshot requestedSnapshot = null;
        if (Constraints.isInRange(0, index, 2)) {
            requestedSnapshot = this.snapshot[index];
        }
        return requestedSnapshot;
    }

    public boolean isSnapshotValid() {
        return this.snapshot[0] != null;
    }

    public void debug() {
        Debug.debug("Snapshot History:");
        Debug.debug("no debug information defined");
    }

    public long getRound() {
        return this.snapshot[0].getRound();
    }

    public long getTime() {
        return this.snapshot[0].getTime();
    }

    public double getEnergy() {
        return this.snapshot[0].getEnergy();
    }

    public double getX() {
        return this.snapshot[0].getX();
    }

    public double getY() {
        return this.snapshot[0].getY();
    }

    public boolean equalsPosition(StaticPosition other) {
        return this.snapshot[0].equalsPosition(other);
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return this.snapshot[0].getRelativePosition(other);
    }

    public StaticVector getRelativeVector(StaticPosition other, double relativeHeading) {
        return this.snapshot[0].getRelativeVector(other, relativeHeading);
    }

    public double getBearing(StaticPosition other) {
        return this.snapshot[0].getBearing(other);
    }

    public double getDistance(StaticPosition other) {
        return this.snapshot[0].getDistance(other);
    }

    public double getHeading() {
        return this.snapshot[0].getHeading();
    }

    public double getRelativeAngle(double other) {
        return this.snapshot[0].getRelativeAngle(other);
    }

    public double getCompoundAngle(double other) {
        return this.snapshot[0].getCompoundAngle(other);
    }

    public double getVelocity() {
        return this.snapshot[0].getVelocity();
    }

    public double getRelativeVelocity(double other) {
        return this.snapshot[0].getRelativeVelocity(other);
    }

    public double getCompoundVelocity(double other) {
        return this.snapshot[0].getCompoundVelocity(other);
    }

    public boolean equalsVector(StaticVector other) {
        return this.snapshot[0].equalsVector(other);
    }

    public StaticVector getRelativeVector(StaticVector other) {
        return this.snapshot[0].getRelativeVector(other);
    }
}

