/*
 * Decompiled with CFR 0.152.
 */
package nic;

public class AccelerationPatternRecogniser {
    public double avgreversetime = -1.0;
    public double standdev = 0.0;
    public long timelastreverse = 0L;
    public boolean accelerating;
    double lastacceleration = 0.0;
    double acceleration = 0.0;
    double lastvelocity;
    double avgreversetimesquared = -1.0;
    long readings;

    public void add(double velocity, long time) {
        this.acceleration = velocity - this.lastvelocity;
        if (this.acceleration > 1.0) {
            this.acceleration = 1.0;
        }
        if (this.acceleration < -1.0) {
            this.acceleration = -1.0;
        }
        if (this.acceleration == 1.0) {
            this.accelerating = true;
        }
        if (this.acceleration == -1.0) {
            this.accelerating = false;
        }
        if (this.acceleration != this.lastacceleration && this.acceleration != 0.0) {
            if (this.avgreversetime == -1.0) {
                this.avgreversetime = time;
                this.avgreversetimesquared = Math.pow(time, 2.0);
                this.readings = 1L;
            } else {
                this.avgreversetime = (this.avgreversetime * (double)this.readings + (double)(time - this.timelastreverse)) / (double)(this.readings + 1L);
                this.avgreversetimesquared = (this.avgreversetimesquared * (double)this.readings + Math.pow(time - this.timelastreverse, 2.0)) / (double)(this.readings + 1L);
                this.standdev = Math.sqrt(this.avgreversetimesquared - Math.pow(this.avgreversetime, 2.0));
                ++this.readings;
            }
            this.timelastreverse = time;
        }
        this.lastvelocity = velocity;
        this.lastacceleration = this.acceleration;
    }

    public void output() {
        System.out.println();
        System.out.println("Average reverse time: " + this.avgreversetime);
        System.out.println("Standard deviation: " + this.standdev);
        System.out.println("Accelerating: " + this.accelerating);
        System.out.println("Time of last reverse: " + this.timelastreverse);
        System.out.println("Acceleration: " + this.acceleration);
        System.out.println();
    }
}

