/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.CollisionBackoff;
import agd.util.Coord;
import agd.util.DiverseGoto;
import agd.util.Enemy;
import agd.util.GotoMethod;
import agd.util.LingerNavStrategy;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;
import agd.util.RobotSighting;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import robocode.HitRobotEvent;

public class HideStrategy
extends AdvancedRobotAdapter
implements NavigationStrategy {
    RobotInformation ri;
    NavigationStrategy lingerStrategy;
    Quadrant[] quadrants = new Quadrant[4];
    Quadrant current = null;
    NavigationStrategy subStrategy = null;
    HitRobotEvent hitRobotEvent = null;
    Coord midpoint = null;
    double LINGER_INDENT = 150.0;

    public HideStrategy(RobotInformation ri) {
        this.ri = ri;
        this.lingerStrategy = null;
        double width = ri.getAdvancedRobot().getBattleFieldWidth();
        double height = ri.getAdvancedRobot().getBattleFieldHeight();
        double qwidth = width / 2.0;
        double qheight = height / 2.0;
        this.midpoint = new Coord(qwidth, qheight);
        this.quadrants[0] = new Quadrant(Coord.ORIGIN, this.midpoint, new Coord(this.LINGER_INDENT, this.LINGER_INDENT));
        this.quadrants[1] = new Quadrant(new Coord(this.midpoint.getX(), 0.0), new Coord(width, this.midpoint.getY()), new Coord(width - this.LINGER_INDENT, this.LINGER_INDENT));
        this.quadrants[2] = new Quadrant(new Coord(0.0, height / 2.0), new Coord(width / 2.0, height), new Coord(this.LINGER_INDENT, height - this.LINGER_INDENT));
        this.quadrants[3] = new Quadrant(this.midpoint, new Coord(width, height), new Coord(width - this.LINGER_INDENT, height - this.LINGER_INDENT));
        ri.addListener(this);
    }

    public void discard() {
        this.ri.removeListener(this);
    }

    public boolean isDone() {
        return false;
    }

    public String toString() {
        return "HideStrategy (using " + this.subStrategy + ")";
    }

    public Navigation navigate() {
        if (this.hitRobotEvent != null) {
            Navigator n = (Navigator)this.ri.getAdvancedRobot();
            CollisionBackoff backoff = new CollisionBackoff(this.ri, this.hitRobotEvent, n, this);
            n.setNavigationStrategy(backoff);
            this.hitRobotEvent = null;
            return ((GotoMethod)backoff).navigate();
        }
        Quadrant preferred = this.getPreferredQuadrant();
        if (this.current == null) {
            this.current = preferred;
            Coord destination = preferred.getHideout();
            this.subStrategy = new DiverseGoto(this.ri, destination);
        } else if (this.current != preferred && preferred.getCount() < this.current.getCount() - 2) {
            if (this.subStrategy != null) {
                this.subStrategy.discard();
                this.subStrategy = null;
            }
            this.current = preferred;
            Coord destination = preferred.getHideout();
            this.subStrategy = new DiverseGoto(this.ri, destination);
        } else if (this.subStrategy instanceof DiverseGoto && this.subStrategy.isDone()) {
            this.subStrategy.discard();
            this.subStrategy = new LingerNavStrategy(this.ri, preferred.getHideout());
            ((LingerNavStrategy)this.subStrategy).setRadius(this.LINGER_INDENT - 55.0);
        }
        return this.subStrategy.navigate();
    }

    public void onHitRobot(HitRobotEvent hre) {
        this.hitRobotEvent = hre;
    }

    Quadrant getPreferredQuadrant() {
        Collection enemies = this.ri.getEnemies().values();
        Iterator it = enemies.iterator();
        int idx = 0;
        while (idx < 4) {
            this.quadrants[idx].resetCount();
            ++idx;
        }
        block1: while (it.hasNext()) {
            Enemy enemy = (Enemy)it.next();
            RobotSighting sight = enemy.getLastSighting();
            if (sight == null) continue;
            int q = 0;
            while (q < 4) {
                if (this.quadrants[q].contains(sight.getTheirPosition())) {
                    ++this.quadrants[q].count;
                    continue block1;
                }
                ++q;
            }
        }
        Arrays.sort(this.quadrants);
        return this.quadrants[0];
    }

    class Quadrant
    implements Comparable {
        Coord bottomleft = null;
        Coord topright = null;
        Coord hideout = null;
        int count = 0;
        double threatMeasure = 0.0;

        public Quadrant(Coord bottomleft, Coord topright) {
            this.bottomleft = bottomleft;
            this.topright = topright;
            double width = topright.getX() - bottomleft.getX();
            double height = topright.getY() - bottomleft.getY();
            this.hideout = new Coord(bottomleft.getX() + width / 2.0, bottomleft.getY() + height / 2.0);
        }

        public Quadrant(Coord bottomleft, Coord topright, Coord hideout) {
            this(bottomleft, topright);
            this.hideout = hideout;
        }

        public void resetCount() {
            this.count = 0;
            this.threatMeasure = 0.0;
        }

        public int getCount() {
            return this.count;
        }

        public double getThreatMeasure() {
            return this.threatMeasure;
        }

        public Coord getHideout() {
            return this.hideout;
        }

        boolean contains(Coord point) {
            return point.getX() >= this.bottomleft.getX() && point.getY() >= this.bottomleft.getY() && point.getX() <= this.topright.getX() && point.getY() <= this.topright.getY();
        }

        public int compareTo(Object o) {
            return this.count - ((Quadrant)o).count;
        }

        public String toString() {
            return "Quadrant {" + this.bottomleft + " - " + this.topright + "}";
        }
    }
}

