/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.FastGoto;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.RobotInformation;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;

public abstract class WaypointNavStrategy
extends AdvancedRobotAdapter
implements NavigationStrategy {
    Coord currentDestination;
    ListIterator currentLeg;
    List waypoints = new LinkedList();
    long timeLastHitRobot = -10L;
    HitRobotEvent lastHitRobotEvent = null;
    RobotInformation robot = null;
    GotoMethod substrat;
    GotoMethod subGotoMethd = null;

    public WaypointNavStrategy(RobotInformation r) {
        this.robot = r;
        this.currentLeg = null;
        this.currentDestination = null;
        this.createWaypoints();
        this.robot.addListener(this);
        this.setUnderlyingGotoMethod(new FastGoto(this.robot, this.robot.getPosition()));
    }

    public void discard() {
        this.robot.removeListener(this);
    }

    public void setUnderlyingGotoMethod(GotoMethod method) {
        this.substrat = method;
        if (this.currentDestination == null) {
            method.setDestination(this.robot.getPosition());
        } else {
            method.setDestination(this.currentDestination);
        }
    }

    public boolean isDone() {
        return false;
    }

    abstract void createWaypoints();

    public void onHitRobot(HitRobotEvent hre) {
        if (this.currentLeg != null && this.currentLeg.hasNext()) {
            this.currentDestination = (Coord)this.currentLeg.next();
        }
        this.timeLastHitRobot = this.robot.getAdvancedRobot().getTime();
        this.lastHitRobotEvent = hre;
        this.nextWaypoint();
    }

    void nextWaypoint() {
        if (!this.currentLeg.hasNext()) {
            this.currentLeg = this.waypoints.listIterator(0);
        }
        this.currentDestination = (Coord)this.currentLeg.next();
        if (this.substrat != null) {
            this.substrat.discard();
        }
        this.substrat.setDestination(this.currentDestination);
    }

    public Navigation navigate() {
        AdvancedRobot ar = this.robot.getAdvancedRobot();
        Navigation nav = null;
        Compass robotHeading = new Compass(ar.getHeading());
        Coord robotLocation = this.robot.getPosition();
        boolean newDestination = false;
        if (ar.getTime() - this.timeLastHitRobot < 5L) {
            nav = new Navigation(new Double(-100.0), new Double(this.lastHitRobotEvent.getBearing()));
        } else {
            double distance;
            if (this.currentDestination == null) {
                this.currentLeg = this.waypoints.listIterator(1);
                this.currentDestination = (Coord)this.currentLeg.previous();
                newDestination = true;
                this.substrat.setDestination(this.currentDestination);
            }
            if ((distance = this.robot.getPosition().distanceTo(this.currentDestination)) < 50.0) {
                this.nextWaypoint();
                newDestination = true;
            }
            nav = this.substrat.navigate();
        }
        return nav;
    }
}

