/*
 * Decompiled with CFR 0.152.
 */
package mz;

import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class AntiGrav
extends AdvancedRobot {
    static Hashtable enemies = new Hashtable();
    static Enemy target;
    static Point2D.Double myPos;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        target = new Enemy();
        while (true) {
            myPos = new Point2D.Double(this.getX(), this.getY());
            if (this.getTime() > 9L) {
                this.moveShoot();
            }
            this.execute();
        }
    }

    public void moveShoot() {
        if (this.getEnergy() > (double)2) {
            this.setFire(800.0 / myPos.distance(AntiGrav.target.position));
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(AntiGrav.calcAngle(AntiGrav.target.position, myPos) - this.getGunHeadingRadians())));
        double x = 0.0;
        double y = 0.0;
        Enumeration enumeration = enemies.elements();
        while (enumeration.hasMoreElements()) {
            Enemy en = (Enemy)enumeration.nextElement();
            if (!en.alive) continue;
            x += Math.sin(AntiGrav.calcAngle(myPos, en.position)) / myPos.distanceSq(en.position) * Math.min((double)2, en.energy / this.getEnergy());
            y += Math.cos(AntiGrav.calcAngle(myPos, en.position)) / myPos.distanceSq(en.position) * Math.min((double)2, en.energy / this.getEnergy());
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(x += (double)5 / Math.pow(AntiGrav.myPos.x, 3) - (double)5 / Math.pow(this.getBattleFieldWidth() - AntiGrav.myPos.x, 3), y += (double)5 / Math.pow(AntiGrav.myPos.y, 3) - (double)5 / Math.pow(this.getBattleFieldHeight() - AntiGrav.myPos.y, 3)) - this.getHeadingRadians())));
        this.setMaxVelocity(Math.max((double)3, Math.min(AntiGrav.myPos.x, Math.min(AntiGrav.myPos.y, Math.min(this.getBattleFieldWidth() - AntiGrav.myPos.x, this.getBattleFieldHeight() - AntiGrav.myPos.y))) / (double)5));
        this.setAhead(100.0);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        ((Enemy)AntiGrav.enemies.get((Object)e.getName())).alive = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en = (Enemy)enemies.get(e.getName());
        if (en == null) {
            en = new Enemy();
            enemies.put(e.getName(), en);
        }
        en.energy = e.getEnergy();
        en.alive = true;
        en.position = AntiGrav.calcPoint(myPos, e.getDistance(), this.getHeadingRadians() + e.getBearingRadians());
        if (!AntiGrav.target.alive || e.getDistance() < myPos.distance(AntiGrav.target.position)) {
            target = en;
        }
        if (this.getOthers() == 1) {
            this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        }
    }

    private static final Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    private static final double calcAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    public class Enemy {
        public Point2D.Double position;
        public double energy;
        public boolean alive;
    }
}

