/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Force;
import fnc.bandit.Position;
import fnc.bandit.Util;

public class BulletAttractor {
    static double r = 20.0;
    double buffer_length = 200.0;
    double w;
    double h;
    Position position;
    Position predicted_position;
    double v;
    String name;
    double d;
    double phi;
    double alpha;
    boolean left;
    boolean on_target;
    boolean chosen;
    double escape_heading;

    public BulletAttractor(String string, Position position, double d, double d2, double d3) {
        this.w = d2;
        this.h = d3;
        this.v = d;
        this.position = new Position(position);
        this.predicted_position = new Position(position);
        this.name = string;
        this.d = 0.0;
        this.phi = 0.0;
        this.alpha = 0.0;
        this.left = false;
        this.on_target = true;
        this.chosen = false;
        this.escape_heading = 0.0;
    }

    public boolean get_left() {
        return this.left;
    }

    public boolean get_on_target() {
        return this.on_target;
    }

    public double get_d() {
        return this.d;
    }

    public double get_alpha() {
        return this.alpha;
    }

    public String getName() {
        return this.name;
    }

    public void computePosition(double d) {
        double d2 = d - this.position.t;
        double d3 = d2 * this.v;
        this.predicted_position.x = this.position.x + d3 * Math.sin(this.predicted_position.h);
        this.predicted_position.y = this.position.y + d3 * Math.cos(this.predicted_position.h);
    }

    public Position getPosition(double d) {
        this.computePosition(d);
        return this.predicted_position;
    }

    public Force adjustForce(Position position, Force force) {
        Position position2;
        boolean bl = false;
        if (position.x > this.w - this.buffer_length || position.x < this.buffer_length) {
            position2 = new Position(this.w / 2.0, this.h / 2.0);
            force.rotate(Math.PI);
            bl = true;
        }
        if ((position.y > this.h - this.buffer_length || position.y < this.buffer_length) && !bl) {
            position2 = new Position(this.w / 2.0, this.h / 2.0);
            force.rotate(Math.PI);
        }
        return force;
    }

    public final Force force(Position position, double d) {
        Force force = new Force();
        force.setForce(this.position, position, 0.0);
        this.d = this.position.distance(position);
        double d2 = Util.normalize(this.position.bearing(position));
        this.alpha = Util.normalize(Util.normalize(this.position.h) - d2);
        double d3 = Math.abs(this.alpha);
        if (d3 > 1.5707963267948966) {
            this.on_target = false;
        } else {
            this.left = !(this.alpha > 0.0);
            double d4 = this.d * Math.cos(d3);
            double d5 = this.d * Math.sin(d3);
            if (d5 < r) {
                this.on_target = true;
                double d6 = Math.asin(d5 / r);
                double d7 = r * Math.cos(d6);
                double d8 = d4 - d7;
                double d9 = d8 / this.v;
                double d10 = d - this.position.t - d9;
                if (!(d9 < 0.0)) {
                    double d11 = this.left ? Util.normalize(this.position.h - 1.5707963267948966 + d3) : Util.normalize(this.position.h + 1.5707963267948966 + d3);
                    if (!this.chosen) {
                        this.chosen = true;
                        this.escape_heading = d11;
                    }
                    force.setForce(this.escape_heading, 1.0);
                    force = this.adjustForce(position, force);
                    this.escape_heading = force.bearing();
                }
            } else {
                this.on_target = false;
                if (this.d < 4.0 * r) {
                    double d12 = this.left ? Util.normalize(this.position.h - 1.5707963267948966 + d3) : Util.normalize(this.position.h + 1.5707963267948966 + d3);
                    if (!this.chosen) {
                        this.chosen = true;
                        this.escape_heading = d12;
                    }
                    force.setForce(this.escape_heading, 1.0);
                    force = this.adjustForce(position, force);
                    this.escape_heading = force.bearing();
                }
            }
        }
        return force;
    }
}

