/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Util;
import java.io.PrintStream;

public class Position {
    final double PI = Math.PI;
    public double x;
    public double y;
    public double t;
    public double h;

    public Position(Position position) {
        this.x = position.x;
        this.y = position.y;
        this.t = position.t;
        this.h = position.h;
    }

    public Position(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.t = 0.0;
        this.h = 0.0;
    }

    public Position(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.t = d3;
        this.h = 0.0;
    }

    public Position(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.t = d3;
        this.h = d4;
    }

    public void set(Position position) {
        this.x = position.x;
        this.y = position.y;
        this.t = position.t;
        this.h = position.h;
    }

    public String toString() {
        return "(" + Util.round(this.x) + "," + Util.round(this.y) + "," + Util.round(this.t) + " " + Util.round(this.h) + ")";
    }

    public void dump(PrintStream printStream) {
        printStream.println("(" + this.x + "," + this.y + "," + this.t + ")");
    }

    public double distance(Position position) {
        double d = this.x - position.x;
        double d2 = this.y - position.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    public double bearing(Position position) {
        double d = position.x - this.x;
        double d2 = position.y - this.y;
        double d3 = Math.atan2(d, d2);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }
}

