/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import pedersen.core.Constraints;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class Arena {
    private final double minX = 0.0;
    private final double minY = 0.0;
    private double maxX = 0.0;
    private double maxY = 0.0;
    private StaticPosition center;
    public static final Arena singleton = new Arena();
    public static final double north = 0.0;
    public static final double northEast = 0.7853981633974483;
    public static final double east = 1.5707963267948966;
    public static final double southEast = 2.356194490192345;
    public static final double south = Math.PI;
    public static final double southWest = 3.9269908169872414;
    public static final double west = 4.71238898038469;
    public static final double northWest = 5.497787143782138;

    private Arena() {
    }

    public static void init(double battleFieldWidth, double battleFieldHeight) {
        Arena.singleton.maxX = battleFieldWidth;
        Arena.singleton.maxY = battleFieldHeight;
        singleton.getClass();
        double d = (0.0 + Arena.singleton.maxX) * 0.5;
        singleton.getClass();
        Arena.singleton.center = new StaticPositionImpl(d, (0.0 + Arena.singleton.maxY) * 0.5);
    }

    public static boolean isInBoundary(StaticPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(0.0, position.getX(), Arena.singleton.maxX)) {
            singleton.getClass();
            if (Constraints.isInRange(0.0, position.getY(), Arena.singleton.maxY)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVehicleCenterInBoundary(StaticPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(0.0 + 18.0, position.getX(), Arena.singleton.maxX - 18.0)) {
            singleton.getClass();
            if (Constraints.isInRange(0.0 + 18.0, position.getY(), Arena.singleton.maxY - 18.0)) {
                return true;
            }
        }
        return false;
    }

    public static StaticPosition getCenter() {
        return Arena.singleton.center;
    }

    public static double getMinX() {
        singleton.getClass();
        return 0.0;
    }

    public static double getMinY() {
        singleton.getClass();
        return 0.0;
    }

    public static double getMaxX() {
        return Arena.singleton.maxX;
    }

    public static double getMaxY() {
        return Arena.singleton.maxY;
    }
}

