/*
 * Decompiled with CFR 0.152.
 */
package catcat20;

import catcat20.bot.Bot;
import catcat20.gun.LambdaGun;
import catcat20.move.Surfing;
import catcat20.radar.Radar;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import catcat20.utils.PreciseWallSmooth;
import catcat20.utils.SimplexNoise;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;
import wiki.mc2k7.RaikoGun;

public class Lambda
extends TeamRobot {
    public static int[] finishes;
    public static Radar radar;
    public static Surfing surfing;
    public static LambdaGun gun;
    public static RaikoGun raikoGun;
    public double wallHitLost = 0.0;
    public double wallHitCount = 0.0;
    public double lastVel;
    public boolean win = false;
    public int winDirection = 1;
    public PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();

    public void resetConstants() {
        LConstants.TC_MODE = false;
        LConstants.MC_MODE = false;
        LConstants.MC2k7_MODE = false;
        LConstants.GUN_COOLING_RATE = this.getGunCoolingRate();
        LConstants.fieldWidth = this.getBattleFieldWidth();
        LConstants.fieldHeight = this.getBattleFieldHeight();
        LConstants.field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        int margin = 20;
        LConstants.safeField = new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - (double)(margin * 2), this.getBattleFieldHeight() - (double)(margin * 2));
        LConstants.fieldCenter = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        int surfMargin = 38;
        LConstants.surfField = new Rectangle2D.Double(surfMargin, surfMargin, this.getBattleFieldWidth() - (double)(surfMargin * 2), this.getBattleFieldHeight() - (double)(surfMargin * 2));
        LConstants.cornerX = new double[]{0.0, 0.0, LConstants.fieldWidth, LConstants.fieldWidth};
        LConstants.cornerY = new double[]{0.0, LConstants.fieldHeight, 0.0, LConstants.fieldHeight};
        LConstants.preciseWallSmooth = new PreciseWallSmooth(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        double round = 114.5450131316624;
        round = 230.0;
        margin = 19;
        LConstants.widthRect = new Rectangle2D.Double(margin, round, this.getBattleFieldWidth() - (double)margin, this.getBattleFieldHeight() - round);
        LConstants.heightRect = new Rectangle2D.Double(round, margin, this.getBattleFieldWidth() - round, this.getBattleFieldHeight() - (double)margin);
        LConstants.roundRect = new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - (double)(margin * 2), this.getBattleFieldHeight() - (double)(margin * 2), round, round);
    }

    public void setDefaultColor() {
        float green = 0.1f;
        float blueMul = 2.5f;
        float bodyCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setBodyColor(new Color(bodyCol, green, bodyCol * blueMul));
        float gunCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setGunColor(new Color(gunCol, green, gunCol * blueMul));
        float radarCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setRadarColor(new Color(radarCol, green, radarCol * blueMul));
        float scanArcCol = (float)(Math.random() * 25.0) / 255.0f;
        this.setScanColor(new Color(scanArcCol + 0.19607843f, 0.0f, scanArcCol * 2.0f + 0.29411766f));
        float bulCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        this.setBulletColor(new Color(bulCol, green, bulCol * blueMul));
    }

    public void setWinColor() {
        float green = 0.1f;
        float blueMul = 2.5f;
        float bodyCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float gunCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float radarCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        float scanArcCol = (float)(Math.random() * 25.0) / 255.0f;
        float bulCol = (float)(Math.random() * 5.0 + 20.0) / 255.0f;
        double mapSize = 250.0;
        double noise = (SimplexNoise.noise(this.getX() / mapSize, this.getY() / mapSize) + 1.0) / 2.0;
        blueMul = 2.5f;
        bodyCol = (float)(noise * 100.0 + 0.0) / 255.0f;
        this.setBodyColor(new Color(bodyCol, green, bodyCol * blueMul));
        gunCol = (float)(noise * 100.0 + 0.0) / 255.0f;
        this.setGunColor(new Color(gunCol, green, gunCol * blueMul));
        radarCol = (float)(noise * 100.0 + 0.0) / 255.0f;
        this.setRadarColor(new Color(radarCol, green, radarCol * blueMul));
        blueMul = 1.5f;
        scanArcCol = (float)(noise * 122.0 + 0.0) / 255.0f;
        this.setScanColor(new Color(0.09803922f + scanArcCol * 75.0f / 255.0f, 0.0f, 0.19607843f + scanArcCol * 75.0f / 255.0f));
        blueMul = 2.0f;
        bulCol = (float)(noise * 122.0 + 0.0) / 255.0f;
        this.setBulletColor(new Color(bulCol, green, bulCol * blueMul));
    }

    public void winMove() {
        this.setMaxVelocity(8.0);
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustRadarForRobotTurn(false);
        double power = 3.0;
        power = Math.min(this.getEnergy() - 0.1, power);
        if (this.getEnergy() > power + 0.1) {
            this.setFire(power);
        }
        this.setTurnGunRightRadians(Double.POSITIVE_INFINITY * (double)this.winDirection * 1.0);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY * (double)this.winDirection * 1.0);
        double angle = LUtils.absoluteBearing(this.getX(), this.getY(), LConstants.fieldCenter.x, LConstants.fieldCenter.y);
        this.trig.sin = Math.sin(angle -= 1.5707963267948966 * (double)this.winDirection * 1.5);
        this.trig.cos = Math.cos(angle);
        angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, this.getX(), this.getY(), this.winDirection);
        this.trig.sin = Math.sin(angle);
        this.trig.cos = Math.cos(angle);
        angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, this.getX(), this.getY(), this.winDirection);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(angle - this.getHeadingRadians())));
        Lambda.setBackAsFront((AdvancedRobot)this, angle);
    }

    public void run() {
        System.gc();
        this.win = false;
        this.winDirection = LUtils.sign(Math.random() - 0.5);
        this.resetConstants();
        if (radar == null) {
            finishes = new int[this.getOthers() + 1];
            radar = new Radar(this);
            surfing = new Surfing(this);
            gun = new LambdaGun(this);
            raikoGun = new RaikoGun((AdvancedRobot)this);
        }
        radar.init();
        surfing.init();
        gun.init();
        this.setDefaultColor();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            if (Surfing._waves.isEmpty() && this.win) {
                this.setWinColor();
                this.winMove();
                this.execute();
                continue;
            }
            radar.onTick();
            Surfing.nextMyPos = new Point2D.Double(this.getX(), this.getY());
            if (!LConstants.TC_MODE) {
                surfing.onTick();
            }
            if (!LConstants.MC_MODE && !LConstants.MC2k7_MODE) {
                gun.onTick();
            }
            this.lastVel = this.getVelocity();
            this.execute();
        }
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void endTask() {
        gun.endTask();
        surfing.endTask();
        System.out.println();
        System.out.println("wall lost: " + this.wallHitLost + " (" + this.wallHitCount + ")");
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        surfing.onSkippedTurn(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        radar.onScannedRobot(e);
        if (LConstants.MC2k7_MODE) {
            raikoGun.onScannedRobot(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        gun.onBulletHit(e);
        Bot bot = Radar.getBot(e.getName());
        if (bot != null && bot.currentState != null) {
            bot.currentState.energy -= Rules.getBulletDamage((double)e.getBullet().getPower());
            bot.states.get((int)1).energy -= Rules.getBulletDamage((double)e.getBullet().getPower());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bot bot = Radar.getBot(e.getName());
        if (bot != null) {
            bot.currentState.energy += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        }
        surfing.onHitByBullet(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        surfing.onBulletHitBullet(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        radar.onRobotDeath(e);
    }

    public void onDeath(DeathEvent e) {
        this.endTask();
        int n = this.getOthers();
        finishes[n] = finishes[n] + 1;
        System.out.println("finishes: " + Arrays.toString(finishes));
    }

    public void onWin(WinEvent e) {
        this.endTask();
        finishes[0] = finishes[0] + 1;
        System.out.println("finishes: " + Arrays.toString(finishes));
        this.win = true;
    }

    public void onHitWall(HitWallEvent e) {
        this.wallHitLost += Rules.getWallHitDamage((double)this.lastVel);
        this.wallHitCount += 1.0;
        System.out.println("[" + e.getTime() + "] hit wall " + this.getVelocity() + ", " + this.lastVel);
    }

    public void onPaint(Graphics2D g) {
        surfing.onPaint(g);
        gun.onPaint(g);
    }
}

