/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.botUtil;

import de.simpleworks.robocode.botUtil.Coordinate;
import robocode.ScannedRobotEvent;

public abstract class Targeter {
    public Coordinate impactPoint = new Coordinate(0.0, 0.0);
    public double bulletHeading_deg;
    protected Coordinate bulletStartingPoint = new Coordinate();
    protected Coordinate targetStartingPoint = new Coordinate();
    public double targetHeading;
    public double targetVelocity;
    public double bulletPower;
    public double distance;
    protected double impactTime;

    public abstract void calculate(ScannedRobotEvent var1, double var2, double var4, double var6, double var8, double var10);

    public boolean canHit() {
        return true;
    }

    protected Coordinate getEstimatedPosition(double time) {
        double x = this.targetStartingPoint.x() + this.targetVelocity * time * Math.sin(Math.toRadians(this.targetHeading));
        double y = this.targetStartingPoint.y() + this.targetVelocity * time * Math.cos(Math.toRadians(this.targetHeading));
        return new Coordinate(x, y);
    }

    protected double f(double time) {
        double vb = 20.0 - 3.0 * this.bulletPower;
        Coordinate targetPosition = this.getEstimatedPosition(time);
        double dX = targetPosition.x() - this.bulletStartingPoint.x();
        double dY = targetPosition.y() - this.bulletStartingPoint.y();
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    protected double getImpactTime(double t0, double t1, double accuracy) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }
}

