/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4;

import gre.svman4.LeonidasInfo;
import gre.svman4.attack.Attack;
import gre.svman4.enemies.Enemy;
import gre.svman4.guns.Gun;
import gre.svman4.guns.GunInformation;
import gre.svman4.guns.LearningGuns.LearningGun;
import gre.svman4.guns.LearningGuns.guessFactorGun.GuessFactorGun;
import gre.svman4.guns.NoGun;
import gre.svman4.guns.OneVsOne.LinearTargetingGun;
import gre.svman4.guns.mellee.AreaTargetingGun;
import gre.svman4.moves.LearningMove.LearningMove;
import gre.svman4.moves.MeleeMove.AntigravityMovement;
import gre.svman4.moves.Move;
import gre.svman4.moves.MovingOrder;
import gre.svman4.moves.NoMove;
import gre.svman4.moves.oneVsOneMove.RamMove;
import gre.svman4.radars.MeleeRadar;
import gre.svman4.radars.OneVsOneRadar;
import gre.svman4.radars.Radar;
import gre.svman4.strategy.IStrategyChangeListener;
import gre.svman4.strategy.Strategy;
import gre.svman4.strategy.StrategyChangeEvent;
import gre.svman4.useful.CalculateDamageFromBullet;
import gre.svman4.useful.CalculateDamageFromHitWall;
import gre.svman4.useful.LastPositionHolder;
import gre.svman4.useful.MotionState;
import gre.svman4.useful.RobotState;
import gre.svman4.useful.SpeedLimitCalculator;
import gre.svman4.useful.TargetControlled;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Leonidas
extends AdvancedRobot {
    private static Rectangle2D.Double _battleField;
    private static final HashMap<String, Enemy> _enemies;
    private static Gun[] _guns;
    private static final RobotState _me;
    private static Move[] _moves;
    private static Radar[] _radars;
    private static boolean _showBattleField;
    private static boolean _showGun;
    private static boolean _showMovement;
    private static boolean _showRadar;
    private static boolean _showTarget;
    private static Enemy _target;
    private final ArrayList<Attack> _enemiesAttacks = new ArrayList();
    private Gun _gun;
    private final ArrayList<Attack> _MineVirtualattacks = new ArrayList();
    private Move _move;
    private Radar _radar;
    private Strategy _strategy = Strategy.Nothing;
    private final List<Attack> paintAttack = new ArrayList<Attack>();
    private ArrayList<IStrategyChangeListener> strategyChangeListener = new ArrayList();

    static {
        _enemies = new HashMap();
        _me = new RobotState();
        _showBattleField = false;
        _showGun = false;
        _showMovement = true;
        _showRadar = true;
        _showTarget = true;
        _target = new Enemy("", (MotionState)_me);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        super.onSkippedTurn(event);
        System.out.println("Lost a turn");
    }

    private void createNewVirtualAttack(double bulletPower, Enemy target, boolean paint) {
        Attack attack = new Attack(this.getTime(), _me, target);
        attack._velocity = Rules.getBulletSpeed((double)bulletPower);
        attack._isPainted = paint;
        this._MineVirtualattacks.add(attack);
    }

    private void doJobsOnBattleStart() {
        Leonidas._me.name = this.getName();
        System.out.println("My name is " + Leonidas._me.name);
        _battleField = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        System.out.println("WALL_MARGIN=" + LeonidasInfo.WALL_MARGIN);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setRadars();
        this.setGuns();
        this.setMoves();
    }

    private void drawCompleteAttackGraphics(Graphics2D paint) {
        this.paintAttack.forEach(attack -> {
            paint.setColor(Color.RED);
            MotionState startPoint = attack._shooterLog.robotPoint;
            MotionState expectedPoint = attack._targetLog.robotPoint;
            MotionState hitTargetPoint = attack._hitTargetLog.robotPoint;
            paint.fillOval((int)(startPoint.x - 4.0), (int)(startPoint.y - 4.0), 8, 8);
            paint.fillOval((int)(expectedPoint.x - 4.0), (int)(expectedPoint.y - 4.0), 8, 8);
            paint.setColor(Color.gray);
            paint.drawLine((int)startPoint.x, (int)startPoint.y, (int)expectedPoint.x, (int)expectedPoint.y);
            paint.setColor(Color.ORANGE);
            paint.drawLine((int)startPoint.x, (int)startPoint.y, (int)hitTargetPoint.x, (int)hitTargetPoint.y);
        });
        this.paintAttack.clear();
    }

    private void enemiesAttackUpdate(long timeNow) {
        Iterator<Attack> enemiesAttack = this._enemiesAttacks.iterator();
        while (enemiesAttack.hasNext()) {
            Attack attack = enemiesAttack.next();
            attack.timeNowIs(timeNow);
            if (!attack.goesToTarget()) continue;
            attack.saveTargetInfo(this.getTime());
            enemiesAttack.remove();
            this.sendToMovesForLearn(attack);
        }
    }

    private Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, 0.9f, 0.9f);
    }

    protected void goTo(double goAngle, double distance) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - Leonidas._me.heading));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                this.setTurnRightRadians(Math.PI + angle);
            } else {
                this.setTurnLeftRadians(Math.PI - angle);
            }
            this.setBack(distance);
        } else {
            if (angle < 0.0) {
                this.setTurnLeftRadians(-1.0 * angle);
            } else {
                this.setTurnRightRadians(angle);
            }
            this.setAhead(distance);
        }
        double speed = SpeedLimitCalculator.calculate(this);
        this.setMaxVelocity(speed);
    }

    private void gun() {
        GunInformation info;
        if (this.getEnergy() <= LeonidasInfo.ENERGY_LIMIT_TO_PREVENT_SHOOTING) {
            return;
        }
        this.selectGun();
        if (this._gun instanceof TargetControlled) {
            ((TargetControlled)((Object)this._gun)).setTarget(_target);
        }
        if ((info = this._gun.getFiringInformation()) == null) {
            return;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(info.shootingAngle - this.getGunHeadingRadians())));
        if (this.getGunHeat() == 0.0 && Math.abs(this.getGunTurnRemaining()) < LeonidasInfo.GUN_TURN_REMAINING_THRESHOLD) {
            this.setFire(info.bulletPower);
            this.createNewVirtualAttack(info.bulletPower, _target, true);
        }
    }

    private void move() {
        MovingOrder order;
        if (this._move != _moves[this._strategy.ordinal()]) {
            this._move = _moves[this._strategy.ordinal()];
        }
        if (this._move instanceof TargetControlled) {
            ((TargetControlled)((Object)this._move)).setTarget(_target);
        }
        if ((order = this._move.getMovingInfo()) != null) {
            this.setMaxVelocity(order.speed);
            this.goTo(order.movingAngle, order.distance);
        }
        LastPositionHolder.refresh(_me);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        _enemies.clear();
        this._MineVirtualattacks.clear();
        this._enemiesAttacks.clear();
        System.out.println("End of battle");
    }

    public void onBulletHit(BulletHitEvent event) {
        Enemy enemy = _enemies.get(event.getName());
        if (enemy == null) {
            enemy = new Enemy(event.getName(), (MotionState)_me);
            _enemies.put(enemy.name, enemy);
        }
        double damage = enemy.energy - event.getEnergy();
        enemy.onBulletHit(event);
        LeonidasInfo.RESULT_DAMAGE_TO_TARGET += damage;
        ++LeonidasInfo.RESULT_HIT_TO_TARGET;
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        String ShooterName = event.getBullet().getName();
        if (!ShooterName.equals(this.getName())) {
            Enemy enemy = _enemies.get(ShooterName);
            if (enemy == null) {
                enemy = new Enemy(event.getBullet().getName(), (MotionState)_me);
                _enemies.put(enemy.name, enemy);
            }
            enemy.onBulletHitBullet(event);
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        Enemy enemy;
        Attack attack = null;
        int i = 0;
        while (i < this._enemiesAttacks.size()) {
            attack = this._enemiesAttacks.get(i);
            if ((double)attack._coverDistance - _me.distance(attack._shootingRobot) < 50.0 && attack._velocity - event.getVelocity() < 1.0E-4) {
                attack.saveTargetInfo(this.getTime());
                this._enemiesAttacks.lastIndexOf(attack);
                break;
            }
            ++i;
        }
        if (attack != null) {
            i = 0;
            do {
                if (!(_moves[i] instanceof LearningMove)) continue;
                ((LearningMove)_moves[i]).learn(attack, true);
            } while (++i < _moves.length);
        }
        if ((enemy = _enemies.get(event.getName())) != null) {
            enemy.onHitByBullet(event, _me);
        }
        double damage = CalculateDamageFromBullet.calculate(event.getPower());
        LeonidasInfo.RESULT_DAMAGE_FROM_ANOTHER_ROBOT += damage;
        ++LeonidasInfo.RESULT_HIT_FROM_ANOTHER_ROBOT;
    }

    public void onHitRobot(HitRobotEvent event) {
        RobotState enemy = _enemies.get(event.getName());
        enemy.energy = event.getEnergy();
        super.onHitRobot(event);
        LeonidasInfo.RESULT_DAMAGE_FROM_HIT_TO_ROBOT += 0.6;
    }

    public void onHitWall(HitWallEvent event) {
        double damage = CalculateDamageFromHitWall.calculate(this.getVelocity());
        LeonidasInfo.RESULT_DAMAGE_FROM_HIT_WALL += damage;
        ++LeonidasInfo.RESULT_HIT_ON_WALL;
    }

    public void onKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 71: {
                _showGun = !_showGun;
                break;
            }
            case 70: {
                _showBattleField = !_showBattleField;
                break;
            }
            case 84: {
                _showTarget = !_showTarget;
                break;
            }
            case 77: {
                _showMovement = !_showMovement;
                break;
            }
            case 82: {
                _showRadar = !_showRadar;
            }
        }
    }

    public void onPaint(Graphics2D paint) {
        if (_showBattleField) {
            paint.setColor(Color.black);
            paint.fillRect(0, 0, (int)this.getBattleFieldWidth(), (int)this.getBattleFieldHeight());
        }
        if (_showRadar) {
            this._radar.onPaint(paint);
            for (Enemy _enemy : _enemies.values()) {
                _enemy.onPaint(paint);
            }
        }
        if (_showMovement) {
            this._move.onPaint(paint);
            this._enemiesAttacks.forEach(attack -> attack.onPaint(paint));
        }
        if (_showGun) {
            this._gun.onPaint(paint);
            this._MineVirtualattacks.forEach(attack -> attack.onPaint(paint));
            this.drawCompleteAttackGraphics(paint);
        }
    }

    public void onRobotDeath(RobotDeathEvent evnt) {
        Enemy en = _enemies.get(evnt.getName());
        if (en == null) {
            return;
        }
        en.alive = false;
    }

    public void onRoundEnded(RoundEndedEvent event) {
        _enemies.values().forEach(enemy -> enemy.onRoundEnd(event));
        this._MineVirtualattacks.clear();
        this._enemiesAttacks.clear();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        Enemy enemy = _enemies.get(event.getName());
        if (enemy == null) {
            enemy = new Enemy(event.getName(), (MotionState)_me);
            _enemies.put(enemy.name, enemy);
        }
        enemy.onScannedRobot(event, _me);
        this._radar.onScannedRobot(event);
        Attack attack = new Attack(this.getTime(), _me, _target);
        attack._velocity = Rules.getBulletSpeed((double)1.5);
        this._MineVirtualattacks.add(attack);
        if (!Leonidas._target.alive || enemy.distance(_me) < _target.distance(_me)) {
            _target = enemy;
            if (this._radar instanceof TargetControlled) {
                ((TargetControlled)((Object)this._radar)).setTarget(_target);
            }
        }
    }

    public void onStatus(StatusEvent event) {
        _me.setLocation(this.getX(), this.getY());
        Leonidas._me.heading = this.getHeadingRadians();
        Leonidas._me.energy = this.getEnergy();
        Leonidas._me.velocity = this.getVelocity();
        Leonidas._me.updateTime = this.getTime();
        _enemies.values().forEach(enemy -> enemy.onStatus(event, _me));
        this.virtualAttackUpdate(event.getTime());
        this.enemiesAttackUpdate(event.getTime());
    }

    public void onWin(WinEvent evnt) {
        this.setMaxVelocity(0.0);
        this.setTurnRight(30.0 - this.getHeading());
        this.setTurnGunRight(50.0 - this.getGunHeading());
        this.setTurnRadarRight(65.0 - this.getRadarHeading());
        this.execute();
    }

    private void radar() {
        if (this._radar != _radars[this._strategy.ordinal()]) {
            this._radar = _radars[this._strategy.ordinal()];
        }
        this._radar.run();
    }

    public void run() {
        if (this.getRoundNum() == 0) {
            this.doJobsOnBattleStart();
        }
        LastPositionHolder.init(_me);
        _target = new Enemy("", (MotionState)_me);
        Leonidas._target.alive = false;
        _enemies.values().forEach(enemy -> {
            enemy.alive = true;
        });
        while (true) {
            this.selectStrategy();
            this.radar();
            this.move();
            this.gun();
            this.execute();
        }
    }

    private void selectGun() {
        if (this._gun != _guns[this._strategy.ordinal()]) {
            this._gun = _guns[this._strategy.ordinal()];
        }
    }

    private void selectStrategy() {
        Strategy tempStrategy = this.getOthers() == 0 ? Strategy.Nothing : (this.getOthers() == 1 ? (Leonidas._target.energy <= LeonidasInfo.ENEMY_ENERGY_TO_RAM ? Strategy.RAM : Strategy.OneVsOne) : (this.getOthers() >= LeonidasInfo.MINIMUM_ENEMIES_FOR_AREA_TARGETING_GUN ? Strategy.TooManyEnemies : Strategy.Melee));
        if (tempStrategy != this._strategy) {
            this._strategy = tempStrategy;
            System.out.println("\u0391\u03bb\u03bb\u03b1\u03b3\u03ae \u03c4\u03b1\u03ba\u03c4\u03b9\u03ba\u03ae\u03c2 \u03c3\u03b5 " + (Object)((Object)this._strategy));
            this.informListenerForStrategyChanger(this._strategy);
        }
    }

    private void informListenerForStrategyChanger(Strategy strat) {
        StrategyChangeEvent event = new StrategyChangeEvent(strat);
        for (IStrategyChangeListener listener : this.strategyChangeListener) {
            listener.onStrategyChangeEvent(event);
        }
    }

    private void sendAttackToGunForLearn(Attack attack) {
        int i = 0;
        do {
            if (!(_guns[i] instanceof LearningGun)) continue;
            ((LearningGun)_guns[i]).learn(attack);
        } while (++i < _guns.length);
    }

    private void sendToMovesForLearn(Attack attack) {
        int i = 0;
        do {
            if (!(_moves[i] instanceof LearningMove)) continue;
            ((LearningMove)_moves[i]).learn(attack, false);
        } while (++i < _moves.length);
    }

    private void setGuns() {
        _guns = new Gun[5];
        Leonidas._guns[Strategy.TooManyEnemies.ordinal()] = new AreaTargetingGun(_me, _enemies);
        Leonidas._guns[Strategy.Melee.ordinal()] = new LinearTargetingGun(_me);
        Leonidas._guns[Strategy.Nothing.ordinal()] = new NoGun(_me);
        GuessFactorGun oneVsOneGun = new GuessFactorGun(this, _me);
        oneVsOneGun.setBattleField(_battleField);
        Leonidas._guns[Strategy.OneVsOne.ordinal()] = new LinearTargetingGun(_me);
        Leonidas._guns[Strategy.RAM.ordinal()] = new LinearTargetingGun(_me);
        this._gun = _guns[Strategy.Nothing.ordinal()];
    }

    private void setMoves() {
        _moves = new Move[5];
        AntigravityMovement antigravity = new AntigravityMovement(_me);
        antigravity.setMovingArea(_battleField);
        antigravity.setEnemies(_enemies);
        Leonidas._moves[Strategy.Melee.ordinal()] = antigravity;
        Leonidas._moves[Strategy.TooManyEnemies.ordinal()] = _moves[Strategy.Melee.ordinal()];
        Leonidas._moves[Strategy.OneVsOne.ordinal()] = _moves[Strategy.Melee.ordinal()];
        Leonidas._moves[Strategy.Nothing.ordinal()] = new NoMove(_me);
        Leonidas._moves[Strategy.RAM.ordinal()] = new RamMove(_me);
        this._move = _moves[Strategy.Nothing.ordinal()];
    }

    private void setRadars() {
        _radars = new Radar[5];
        MeleeRadar meleeRadar = new MeleeRadar(this);
        Leonidas._radars[Strategy.Melee.ordinal()] = meleeRadar;
        meleeRadar.setEnemies(_enemies);
        Leonidas._radars[Strategy.TooManyEnemies.ordinal()] = _radars[Strategy.Melee.ordinal()];
        Leonidas._radars[Strategy.Nothing.ordinal()] = _radars[Strategy.Melee.ordinal()];
        OneVsOneRadar oneVsOneRadar = new OneVsOneRadar(this);
        Leonidas._radars[Strategy.OneVsOne.ordinal()] = oneVsOneRadar;
        Leonidas._radars[Strategy.RAM.ordinal()] = _radars[Strategy.OneVsOne.ordinal()];
        this._radar = _radars[Strategy.Melee.ordinal()];
    }

    private void virtualAttackUpdate(long timeNow) {
        Iterator<Attack> attackIterator = this._MineVirtualattacks.iterator();
        while (attackIterator.hasNext()) {
            Attack attack = attackIterator.next();
            attack.timeNowIs(timeNow);
            if (!attack.goesToTarget()) continue;
            attack.saveTargetInfo(this.getTime());
            attackIterator.remove();
            if (attack._isPainted) {
                this.paintAttack.add(attack);
            }
            this.sendAttackToGunForLearn(attack);
        }
    }
}

