/*
 * Decompiled with CFR 0.152.
 */
package MGAM;

import MGAM.Enemy;
import MGAM.EnemySelection;
import MGAM.Gun;
import MGAM.Movement;
import MGAM.Radar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public abstract class BotMaster
extends AdvancedRobot {
    public Radar radar;
    public Movement movement;
    public Gun gun;
    public EnemySelection selectEnemy;
    public static boolean paintGun = false;
    public static boolean paintMovement = false;
    public static boolean paintRadar = false;
    public Enemy enemy = new Enemy();
    public Enemy self = new Enemy();
    public static Hashtable<String, Enemy> enemies = new Hashtable();
    public static boolean melee = true;
    public static double battlefieldWidth;
    public static double battlefieldHeight;
    public static Rectangle2D.Double battlefieldRect;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        battlefieldWidth = this.getBattleFieldWidth();
        battlefieldHeight = this.getBattleFieldHeight();
        battlefieldRect = new Rectangle2D.Double(17.6, 17.6, battlefieldWidth - 35.2, battlefieldHeight - 35.2);
        this.initialize();
        while (true) {
            melee = this.getOthers() > 1;
            this.updateSelf();
            this.selectBehavior();
            this.executeBehavior();
        }
    }

    protected abstract void selectBehavior();

    protected abstract void initialize();

    private void executeBehavior() {
        this.selectEnemy.select();
        this.radar.scan();
        this.movement.move();
        this.gun.shoot();
        this.execute();
    }

    private void emitEvent(Event e) {
        if (this.radar != null) {
            this.radar.handleEvent(e);
        }
        if (this.movement != null) {
            this.movement.handleEvent(e);
        }
        if (this.gun != null) {
            this.gun.handleEvent(e);
        }
        if (this.selectEnemy != null) {
            this.selectEnemy.handleEvent(e);
        }
    }

    private void emitInputEvent(InputEvent e) {
        if (this.radar != null) {
            this.radar.handleInput(e);
        }
        if (this.movement != null) {
            this.movement.handleInput(e);
        }
    }

    public void updateSelf() {
        this.self.szName = "theBest";
        this.self.dX = this.getX();
        this.self.dY = this.getY();
        this.self.dPrevEnergy = this.self.dEnergy;
        this.self.dEnergy = this.getEnergy();
        this.self.dHeading = this.getHeading();
        this.self.dBearingRad = this.getHeadingRadians();
        this.self.dHeadingRad = Utils.normalAbsoluteAngle((double)this.getHeadingRadians());
        this.self.dAbsoluteBearingRadians = this.self.dBearingRad;
        this.self.dDistance = 0.0;
        this.self.dVelocity = this.getVelocity();
        this.self.bDead = false;
    }

    public void onStatus(StatusEvent e) {
        this.emitEvent((Event)e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy oldData = enemies.get(e.getName());
        if (oldData == null) {
            oldData = new Enemy();
        }
        Enemy newData = oldData.update(e, this);
        enemies.put(e.getName(), newData);
        this.emitEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.emitEvent((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.emitEvent((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        this.emitEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.emitEvent((Event)e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.emitEvent((Event)e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.emitEvent((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy died = enemies.get(e.getName());
        died.bDead = true;
        if (died.szName == this.enemy.szName) {
            this.enemy = new Enemy();
        }
        this.selectEnemy.select();
        this.emitEvent((Event)e);
    }

    public void onWin(WinEvent e) {
        this.finishRound();
        this.emitEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        this.finishRound();
        this.emitEvent((Event)e);
    }

    public void finishRound() {
        for (Enemy dudeGuy : enemies.values()) {
            dudeGuy.bDead = false;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.emitEvent((Event)e);
    }

    public void onKeyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == 'g') {
            paintGun = this.toggleButton(paintGun);
        }
        if (key == 'r') {
            paintRadar = this.toggleButton(paintRadar);
        }
        if (key == 'm') {
            paintMovement = this.toggleButton(paintMovement);
        }
        this.emitInputEvent(e);
    }

    public boolean toggleButton(boolean button) {
        return !button;
    }

    public void onKeyReleased(KeyEvent e) {
        this.emitInputEvent(e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onMousePressed(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onMouseReleased(MouseEvent e) {
        this.emitInputEvent(e);
    }

    public void onPaint(Graphics2D g) {
        if (paintGun) {
            this.gun.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Gun", 0, 50);
        if (paintMovement) {
            this.movement.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Movement", 0, 75);
        if (paintRadar) {
            this.radar.onPaint(g);
            this.selectEnemy.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("Radar", 0, 100);
    }
}

