/*
 * Decompiled with CFR 0.152.
 */
package br2;

import MGAM.BotMaster;
import MGAM.Enemy;
import br2.MD_GunFunction;
import br2.MD_ShootSmart;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import robocode.util.Utils;

public class MD_Bullet {
    public double m_power;
    public double m_speed;
    public int m_age;
    public Point2D.Double m_firePosition;
    double m_currentRadius;
    public boolean m_hitNextFrame;
    public Hashtable<String, Enemy> m_enemiesAtLaunch;
    public MD_ShootSmart m_parentGun;
    public boolean m_isRealBullet;
    public boolean m_isEnemyBullet;
    public double m_fireAngle;
    public Point2D.Double m_position;
    public boolean m_positionDirty;

    public MD_Bullet(double pwr, double xPos, double yPos, MD_ShootSmart parent, double fireAngle, boolean isRealBullet, boolean isEnemyBullet) {
        this.m_parentGun = parent;
        this.m_fireAngle = fireAngle;
        this.m_enemiesAtLaunch = new Hashtable();
        this.m_power = pwr;
        this.m_speed = 20.0 - 3.0 * this.m_power;
        this.m_age = 0;
        this.m_positionDirty = true;
        this.m_position = new Point2D.Double(xPos, yPos);
        this.m_firePosition = new Point2D.Double(xPos, yPos);
        this.m_currentRadius = 0.0;
        this.m_hitNextFrame = false;
        this.m_isRealBullet = isRealBullet;
        this.m_isEnemyBullet = isEnemyBullet;
    }

    public void addEnemy(Enemy target) {
        Enemy copy = new Enemy(target);
        this.m_enemiesAtLaunch.put(target.szName, copy);
    }

    public Point2D.Double getBulletLocation() {
        if (this.m_positionDirty) {
            this.m_positionDirty = false;
            double vecX = this.m_firePosition.x + Math.sin(this.m_fireAngle) * this.m_currentRadius;
            double vecY = this.m_firePosition.y + Math.cos(this.m_fireAngle) * this.m_currentRadius;
            this.m_position.setLocation(vecX, vecY);
        }
        return this.m_position;
    }

    public boolean update() {
        ++this.m_age;
        this.m_currentRadius = (double)this.m_age * this.m_speed;
        this.m_positionDirty = true;
        boolean bTargetsLeft = false;
        if (this.m_enemiesAtLaunch.isEmpty()) {
            return false;
        }
        Vector<Enemy> toRemove = new Vector<Enemy>();
        for (Enemy savedEnemy : this.m_enemiesAtLaunch.values()) {
            Enemy currEnemy;
            if (savedEnemy == null || savedEnemy.bDead) continue;
            if (this.m_isEnemyBullet && savedEnemy.szName == "theBest") {
                currEnemy = this.m_parentGun.bot.self;
            } else {
                BotMaster cfr_ignored_0 = this.m_parentGun.bot;
                currEnemy = BotMaster.enemies.get(savedEnemy.szName);
            }
            bTargetsLeft = true;
            Point2D.Double targetPos = new Point2D.Double(currEnemy.dX, currEnemy.dY);
            double distance = this.m_firePosition.distance(targetPos);
            if (!(distance < this.m_currentRadius)) continue;
            toRemove.add(savedEnemy);
            for (MD_GunFunction gf : this.m_parentGun.mGunFunctions.values()) {
                gf.processVirtualBullet(this.m_firePosition, savedEnemy, currEnemy, this.m_isRealBullet, this.m_isEnemyBullet);
            }
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.m_enemiesAtLaunch.remove(((Enemy)toRemove.get((int)i)).szName);
        }
        return bTargetsLeft;
    }

    public static double findAngle(Point2D.Double a, Point2D.Double b) {
        double deltaX = a.getX() - b.getX();
        double deltaY = a.getY() - b.getY();
        double angle = 0.0;
        if (deltaY == 0.0) {
            if (deltaX < 0.0) {
                angle = Math.PI;
            }
        } else {
            angle = Math.atan(deltaX / deltaY);
            if (deltaY < 0.0) {
                angle += Math.PI;
            }
        }
        angle = Utils.normalRelativeAngle((double)angle);
        return angle;
    }

    public void onPaint(Graphics2D g) {
        if (this.m_isEnemyBullet) {
            g.setColor(new Color(255, 0, 0, 255));
        } else if (this.m_isRealBullet) {
            g.setColor(new Color(255, 255, 0, 240));
        } else {
            g.setColor(new Color(0, 0, 255, 96));
        }
        g.draw(new Ellipse2D.Double(this.m_firePosition.x - this.m_currentRadius, this.m_firePosition.y - this.m_currentRadius, this.m_currentRadius * 2.0, this.m_currentRadius * 2.0));
        if (this.m_isEnemyBullet) {
            Point2D.Double pos = this.getBulletLocation();
            g.drawLine((int)this.m_firePosition.x, (int)this.m_firePosition.y, (int)pos.x, (int)pos.y);
        }
    }
}

