/*
 * Decompiled with CFR 0.152.
 */
package br2;

import MGAM.BotMaster;
import MGAM.Enemy;
import br2.MD_GunFunction;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class MD_GFDirect
extends MD_GunFunction {
    Point2D.Double targetLocation = new Point2D.Double(0.0, 0.0);

    public MD_GFDirect(String name) {
        super(name);
        this.mGunStrength = 3.0;
    }

    @Override
    public double aimGun(BotMaster master) {
        this.mGunStrength = 0.0;
        this.mGunAngle = 0.0;
        for (Enemy currEnemy : BotMaster.enemies.values()) {
            double currentStrength;
            double distance;
            double distMult;
            double confidenceMult;
            if (currEnemy.bDead) continue;
            this.targetLocation.setLocation(currEnemy.dX, currEnemy.dY);
            if (this.targetLocation.getX() < 0.0) {
                this.targetLocation.setLocation(0.0, this.targetLocation.getY());
            } else if (this.targetLocation.getX() > BotMaster.battlefieldWidth) {
                this.targetLocation.setLocation(BotMaster.battlefieldWidth, this.targetLocation.getY());
            }
            if (this.targetLocation.getY() < 0.0) {
                this.targetLocation.setLocation(this.targetLocation.getX(), 0.0);
            } else if (this.targetLocation.getY() > BotMaster.battlefieldHeight) {
                this.targetLocation.setLocation(this.targetLocation.getX(), BotMaster.battlefieldHeight);
            }
            Vector<Double> currData = (Vector<Double>)mGunData.get(currEnemy.szName);
            if (currData == null) {
                currData = new Vector<Double>();
                currData.add(0.5);
                mGunData.put(currEnemy.szName, currData);
            }
            if ((confidenceMult = ((Double)currData.get(0)).doubleValue()) > 1.0) {
                confidenceMult = 1.0;
            }
            if ((distMult = 1.0 - (distance = this.targetLocation.distance(master.self.dX, master.self.dY) / BotMaster.battlefieldHeight)) < 0.1) {
                distMult = 0.1;
            }
            if (!((currentStrength = distMult * confidenceMult * 5.0) > this.mGunStrength)) continue;
            this.mGunStrength = currentStrength;
            this.mGunAngle = this.findAngle(this.targetLocation, new Point2D.Double(master.self.dX, master.self.dY));
        }
        return this.mGunStrength;
    }

    @Override
    public void processVirtualBullet(Point2D.Double firePosition, Enemy originalEnemyData, Enemy newEnemyData, boolean isRealBullet, boolean isEnemyBullet) {
        Vector<Double> oldData = (Vector<Double>)mGunData.get(newEnemyData.szName);
        if (oldData == null) {
            oldData = new Vector<Double>();
            oldData.add(0.5);
            mGunData.put(newEnemyData.szName, oldData);
        }
        double factor = 0.99;
        if (isEnemyBullet) {
            factor = 0.999;
        } else if (!isRealBullet) {
            factor = 0.9999;
        }
        double originalAngle = this.findAngle(firePosition, new Point2D.Double(originalEnemyData.dX, originalEnemyData.dY));
        double newAngle = this.findAngle(firePosition, new Point2D.Double(newEnemyData.dX, newEnemyData.dY));
        double diff = Math.abs(originalAngle - newAngle);
        if (diff < 0.15) {
            double oldVal = 1.0 - (Double)oldData.get(0);
            oldData.set(0, 1.0 - (oldVal *= factor));
        } else {
            oldData.set(0, (Double)oldData.get(0) * factor);
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
    }
}

