/*
 * Decompiled with CFR 0.152.
 */
package vStar;

public class EnergyDeltaStatistics {
    double points_pvp = 0.0;
    double points_mid = 0.0;
    double points_far = 0.0;
    int count_pvp = 0;
    int count_mid = 0;
    int count_far = 0;
    double border_pvp_mid;
    double border_mid_far;

    public EnergyDeltaStatistics(double border_pvp_mid, double border_mid_far, EnergyDeltaStatistics last_stats) {
        this.border_pvp_mid = border_pvp_mid;
        this.border_mid_far = border_mid_far;
        if (last_stats != null) {
            if (last_stats.count_pvp != 0) {
                this.points_pvp = last_stats.average_pvp();
                this.count_pvp = 1;
            }
            if (last_stats.count_mid != 0) {
                this.points_mid = last_stats.average_mid();
                this.count_mid = 1;
            }
            if (last_stats.count_far != 0) {
                this.points_far = last_stats.average_far();
                this.count_far = 1;
            }
        }
    }

    public void register_bullet_succes(double points, double distance) {
        if (distance < this.border_pvp_mid) {
            this.points_pvp += points;
            ++this.count_pvp;
        } else if (this.border_mid_far < distance) {
            this.points_far += points;
            ++this.count_far;
        } else {
            this.points_mid += points;
            ++this.count_mid;
        }
    }

    public double average_pvp() {
        if (this.count_pvp == 0) {
            return 0.0;
        }
        return this.points_pvp / (double)this.count_pvp;
    }

    public double average_mid() {
        if (this.count_mid == 0) {
            return 0.0;
        }
        return this.points_mid / (double)this.count_mid;
    }

    public double average_far() {
        if (this.count_far == 0) {
            return 0.0;
        }
        return this.points_far / (double)this.count_far;
    }

    public String get_most_effective_distance() {
        double pvp = this.average_pvp();
        double mid = this.average_mid();
        double far = this.average_far();
        if (pvp < mid && far < mid) {
            return "middle";
        }
        if (far < pvp) {
            return "pvp";
        }
        return "far";
    }

    public void print_stat() {
        System.out.format("pvp: %.2f (%.2f point from %d measures)%n", this.average_pvp(), this.points_pvp, this.count_pvp);
        System.out.format("mid: %.2f (%.2f point from %d measures)%n", this.average_mid(), this.points_mid, this.count_mid);
        System.out.format("far: %.2f (%.2f point from %d measures)%n", this.average_far(), this.points_far, this.count_far);
    }
}

