/*
 * Decompiled with CFR 0.152.
 */
package vStar;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import robocode.AdvancedRobot;
import vStar.PointCommon;
import vStar.PointThatMoves;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinearEquation {
    private double A;
    private double B;
    private double C;
    private PointCommon start;
    private AdvancedRobot your_tank;

    public LinearEquation(AdvancedRobot tank, PointCommon place, double koef_a, double koef_b, double koef_c) {
        this.your_tank = tank;
        this.start = new PointCommon(place);
        this.A = koef_a;
        this.B = koef_b;
        this.C = koef_c;
    }

    public LinearEquation(PointThatMoves bullet, AdvancedRobot tank) {
        this.your_tank = tank;
        this.start = new PointCommon(bullet);
        PointThatMoves frame = new PointThatMoves(bullet);
        frame.calc_move();
        double diff_x = frame.get_x() - this.start.get_x();
        double diff_y = frame.get_y() - this.start.get_y();
        if (diff_x == 0.0 && diff_y == 0.0) {
            return;
        }
        if (diff_x == 0.0) {
            this.A = 1.0;
            this.B = 0.0;
            this.C = -frame.get_x();
        } else if (diff_y == 0.0) {
            this.A = 0.0;
            this.B = 1.0;
            this.C = -frame.get_y();
        } else {
            this.A = 1.0 / diff_x;
            this.B = -1.0 / diff_y;
            this.C = this.start.get_y() / diff_y - this.start.get_x() / diff_x;
        }
    }

    public void draw(Graphics2D graf) {
        if (this.B == 0.0 && this.A == 0.0) {
            return;
        }
        PointCommon end = this.B < 0.0 ? new PointCommon((this.B * this.your_tank.getBattleFieldHeight() + this.C) / -this.A, this.your_tank.getBattleFieldHeight()) : new PointCommon((this.B * 0.0 + this.C) / -this.A, 0.0);
        graf.setColor(Color.orange);
        graf.drawLine((int)this.start.get_x(), (int)this.start.get_y(), (int)end.get_x(), (int)end.get_y());
    }

    public double get_distance_from_line2point(PointCommon point) {
        return Math.abs((this.A * point.get_x() + this.B * point.get_y() + this.C) / Math.sqrt(this.A * this.A + this.B * this.B));
    }

    public HashMap<Long, PointCommon> filter_points_in_distance(Map<Long, PointCommon> points_in, double distance2equation) {
        HashMap<Long, PointCommon> points_out = new HashMap<Long, PointCommon>();
        for (Map.Entry<Long, PointCommon> time_n_location : points_in.entrySet()) {
            PointCommon cur_point = time_n_location.getValue();
            if (!(this.get_distance_from_line2point(cur_point) < distance2equation)) continue;
            points_out.put(time_n_location.getKey(), cur_point);
        }
        return points_out;
    }

    public PointCommon get_point_lines_crosses(LinearEquation another_line) {
        double determ = this.A * another_line.B - another_line.A * this.B;
        double determ_x = another_line.C * this.B - this.C * another_line.B;
        double determ_y = another_line.A * this.C - this.A * another_line.C;
        if (determ != 0.0) {
            return new PointCommon(determ_x / determ, determ_y / determ);
        }
        if (determ_x == 0.0 && determ_y == 0.0) {
            return new PointCommon(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return new PointCommon(Double.NaN, Double.NaN);
    }

    public LinearEquation create_perpendicular(PointCommon start) {
        double koef_b;
        double koef_a;
        if (this.B != 0.0) {
            koef_a = 1.0;
            koef_b = -this.A / this.B;
        } else {
            koef_a = -this.B / this.A;
            koef_b = 1.0;
        }
        double koef_c = -koef_a * start.get_x() - koef_b * start.get_y();
        return new LinearEquation(this.your_tank, start, koef_a, koef_b, koef_c);
    }
}

