/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Heading;
import shrub.Location;
import shrub.Phasor;
import shrub.TurretInstruction;

public class Turret {
    private int mMode = 0;
    private Location mTurretLocn = new Location();
    private Heading mTurretHdng = new Heading();
    private Heading mTargetHdng = new Heading();
    private Location mTargetLocn = new Location();
    private double mRotateSpeed = 0.0;
    private long mTime = 0L;
    private Phasor mPhasor = new Phasor();

    public void Initialise() {
        this.SetMode(0);
        this.mTurretLocn.Initialise();
        this.mTurretHdng.Initialise();
        this.mTargetHdng.Initialise();
        this.mTargetLocn.Initialise();
        this.mRotateSpeed = 0.0;
        this.mTime = 0L;
        this.mPhasor.Initialise();
    }

    public void SetMode(int newMode) {
        this.mMode = newMode;
    }

    public void SetTime(long newTime) {
        this.mTime = newTime;
    }

    public void SetRotateSpeed(double newRotateSpeed) {
        this.mRotateSpeed = newRotateSpeed;
    }

    public void SetPhasor(Phasor newPhasor) {
        this.mPhasor = newPhasor;
    }

    public void SetTurretHdng(double newTurretHdng) {
        this.mTurretHdng.Set(newTurretHdng);
    }

    public void SetTurretHdng(Heading newTurretHdng) {
        this.mTurretHdng.Set(newTurretHdng.Get());
    }

    public void SetTurretLocn(double turretX, double turretY) {
        this.mTurretLocn.SetX(turretX);
        this.mTurretLocn.SetY(turretY);
    }

    public void SetTurretLocn(Location turretLocn) {
        this.mTurretLocn.Set(turretLocn);
    }

    public void SetTargetHdng(double newTargetHdng) {
        this.mTargetHdng.Set(newTargetHdng);
    }

    public void SetTargetHdng(Heading newTargetHdng) {
        this.mTargetHdng.Set(newTargetHdng.Get());
    }

    public void SetTargetLocn(double targetX, double targetY) {
        this.mTargetLocn.SetX(targetX);
        this.mTargetLocn.SetY(targetY);
    }

    public void SetTargetLocn(Location targetLocn) {
        this.mTargetLocn.Set(targetLocn);
    }

    public TurretInstruction Process() {
        TurretInstruction instruct = new TurretInstruction();
        if (this.mMode == 0) {
            instruct.SetNothing();
        } else if (this.mMode == 1) {
            this.mTargetHdng.SetFromTo(this.mTurretLocn, this.mTargetLocn);
            this.ProcessRotateToHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 2) {
            instruct.SetRotateLeft(this.mRotateSpeed);
        } else if (this.mMode == 3) {
            instruct.SetRotateRight(this.mRotateSpeed);
        } else if (this.mMode == 4) {
            System.out.println("ERROR : Turret::Process, obsolete mode");
        } else if (this.mMode == 5) {
            System.out.println("ERROR : Turret::Process, obsolete mode");
        } else if (this.mMode == 6) {
            this.ProcessRotateToHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 7) {
            this.ProcessPhasedAroundHeading(instruct, this.mTargetHdng);
        } else if (this.mMode == 8) {
            this.mTargetHdng.SetFromTo(this.mTurretLocn, this.mTargetLocn);
            this.ProcessPhasedAroundHeading(instruct, this.mTargetHdng);
        } else {
            System.out.println("ERROR : Turret::Process, unexpected mode");
        }
        return instruct;
    }

    public void ProcessRotateToHeading(TurretInstruction instruct, Heading toHdng) {
        Bearing relBearing = new Bearing();
        relBearing.SetFromTo(this.mTurretHdng, toHdng);
        double amount = this.mRotateSpeed;
        if (relBearing.GetAbs() < amount) {
            amount = relBearing.GetAbs();
        }
        if (relBearing.IsLeft()) {
            instruct.SetRotateLeft(amount);
        } else if (relBearing.IsRight()) {
            instruct.SetRotateRight(amount);
        } else {
            instruct.SetNothing();
        }
    }

    public void ProcessPhasedAroundHeading(TurretInstruction instruct, Heading rawHdng) {
        this.mPhasor.SetTimeNow(this.mTime);
        double phaseValue = this.mPhasor.GetPhaseValue();
        Heading adjHdng = new Heading();
        adjHdng.Set(rawHdng);
        adjHdng.Adjust(phaseValue);
        this.ProcessRotateToHeading(instruct, adjHdng);
    }

    public Turret() {
        this.Initialise();
    }
}

