/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.detection;

import ghent.common.Target;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class TargetFactory {
    public static Target createTarget(AdvancedRobot robot, ScannedRobotEvent sre) {
        Target target = new Target();
        target.setName(sre.getName());
        return TargetFactory.updateTarget(robot, target, sre);
    }

    public static Target createTarget(AdvancedRobot robot, HitRobotEvent hre) {
        Target target = new Target();
        target.setName(hre.getName());
        return TargetFactory.updateTarget(robot, target, hre);
    }

    public static Target createTarget(AdvancedRobot robot, BulletHitEvent bhe) {
        Target target = new Target();
        target.setName(bhe.getName());
        target.setLocation(bhe.getBullet().getX(), bhe.getBullet().getY());
        return TargetFactory.updateTarget(robot, target, bhe);
    }

    public static Target updateTarget(AdvancedRobot robot, Target target, ScannedRobotEvent sre) {
        target.setEnergy(sre.getEnergy());
        target.setLocation(robot.getHeading() + sre.getBearing(), sre.getDistance(), robot.getX(), robot.getY());
        target.setHeading(sre.getHeading(), sre.getTime());
        target.setVelocity(sre.getVelocity());
        return target;
    }

    public static Target updateTarget(AdvancedRobot robot, Target target, HitRobotEvent hre) {
        target.setEnergy(hre.getEnergy());
        target.setLocation(robot.getHeading() + hre.getBearing(), 0.1, robot.getX(), robot.getY());
        return target;
    }

    public static Target updateTarget(AdvancedRobot robot, Target target, BulletHitEvent bhe) {
        target.setEnergy(bhe.getEnergy());
        return target;
    }

    public static Target updateTarget(AdvancedRobot robot, Target target, HitByBulletEvent hbbe) {
        target.addEnergy(Rules.getBulletHitBonus((double)hbbe.getPower()));
        return target;
    }
}

