/*
 * Decompiled with CFR 0.152.
 */
package eem.target;

import eem.misc.graphics;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.profiler;
import eem.target.botStatPoint;
import eem.target.matchedEnds;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class InfoBot {
    protected String name = "";
    public LinkedList<botStatPoint> botStats;
    public boolean targetUnlocked = true;
    protected int bulletHitCount = 0;
    protected int bulletFiredCount = 0;
    protected HashMap<String, int[]> guessFactorsMap;
    protected HashMap<String, Integer> guessFactorsTotalCounts;
    protected HashMap<String, Integer> guessFactorsMaxCounts;
    protected int numGuessFactorBins = 31;
    protected int maxDepthOfHistorySearch = 500;
    protected int nRequiredMatches = 100;
    protected matchedEnds _matchedEnds = new matchedEnds();

    public InfoBot() {
        this.botStats = new LinkedList();
        this.guessFactorsMap = new HashMap();
        this.guessFactorsTotalCounts = new HashMap();
        this.guessFactorsMaxCounts = new HashMap();
    }

    public InfoBot(String string) {
        this();
        this.setName(string);
    }

    public int getBulletFiredCount() {
        return this.bulletFiredCount;
    }

    public int getBulletHitCount() {
        return this.bulletHitCount;
    }

    protected void incBulletFiredCount() {
        ++this.bulletFiredCount;
    }

    public void incBulletHitCount() {
        ++this.bulletHitCount;
    }

    public double getGunHitRate() {
        return (double)this.getBulletHitCount() / ((double)this.getBulletFiredCount() + 1.0);
    }

    public int[] getGuessFactorBins(InfoBot infoBot) {
        String string = infoBot.getName();
        if (!this.guessFactorsMap.containsKey(string)) {
            int[] nArray = new int[this.numGuessFactorBins];
            this.guessFactorsMap.put(string, nArray);
        }
        return this.guessFactorsMap.get(string);
    }

    public void printGunsStats() {
        String string = String.format("%4d", this.getBulletHitCount());
        String string2 = String.format("%-4d", this.getBulletFiredCount());
        String string3 = "";
        string3 = string3 + "Enemy gun ratio of hit/fired: " + string + "/" + string2;
        string3 = string3 + " = " + logger.shortFormatDouble(100.0 * this.getGunHitRate()) + "%";
        string3 = string3 + " | ";
        string3 = string3 + this.getName();
        logger.routine(string3);
    }

    public void printGFstats(InfoBot infoBot) {
        String string = this.guessFactorBins2string(infoBot);
        logger.routine(" [ " + string + "]" + " by bot: " + this.getName());
    }

    public void initTic(long l) {
        if (l - this.getLastSeenTime() > 2L) {
            this.setUnLockedStatus(true);
        } else {
            this.setUnLockedStatus(false);
        }
        if (this.didItFireABullet(l)) {
            this.incBulletFiredCount();
        }
    }

    public boolean hasLast() {
        int n = this.botStats.size();
        return n >= 1;
    }

    public boolean hasPrev() {
        int n = this.botStats.size();
        return n >= 2;
    }

    public botStatPoint getLast() {
        if (this.hasLast()) {
            return this.botStats.getLast();
        }
        return null;
    }

    public botStatPoint getPrev() {
        int n = this.botStats.size();
        if (this.hasPrev()) {
            return this.botStats.get(n - 2);
        }
        return null;
    }

    public InfoBot update(Point2D.Double double_, long l) {
        this.botStats.add(new botStatPoint(double_, l));
        this.updateEndsOfMatchedSegments();
        return this;
    }

    public InfoBot update(botStatPoint botStatPoint2) {
        String string = "InfoBot.update for " + this.getName();
        profiler.start(string);
        this.botStats.add(botStatPoint2);
        this.updateEndsOfMatchedSegments();
        this.targetUnlocked = false;
        profiler.stop(string);
        return this;
    }

    public double getEnergy() {
        if (this.hasLast()) {
            return this.getLast().getEnergy();
        }
        return 0.0;
    }

    public Point2D.Double getVelocity() {
        if (this.hasLast()) {
            return this.getLast().getVelocity();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public void setName(String string) {
        this.name = string;
    }

    public double getLastDistance(Point2D.Double double_) {
        if (this.hasLast()) {
            return this.getLast().getDistance(double_);
        }
        return 1000000.0;
    }

    public double getX() {
        if (this.hasLast()) {
            return this.getLast().getX();
        }
        return 0.0;
    }

    public double getY() {
        if (this.hasLast()) {
            return this.getLast().getY();
        }
        return 0.0;
    }

    public Point2D.Double getPosition() {
        if (this.hasLast()) {
            return this.getLast().getPosition();
        }
        return new Point2D.Double(0.0, 0.0);
    }

    public Point2D.Double getPrevTicPosition() {
        Point2D.Double double_ = this.getPositionAtTime(this.getLast().getTime() - 1L);
        if (double_ == null) {
            double_ = (Point2D.Double)this.getPosition().clone();
            double_.x -= this.getVelocity().x;
            double_.y -= this.getVelocity().y;
        }
        return double_;
    }

    public Point2D.Double getPrevPosition() {
        if (this.hasPrev()) {
            return this.getPrev().getPosition();
        }
        return null;
    }

    public Point2D.Double getPositionAtTime(long l) {
        botStatPoint botStatPoint2 = this.getStatAtTime(l);
        if (botStatPoint2 == null) {
            return null;
        }
        return botStatPoint2.getPosition();
    }

    public botStatPoint getStatAtTime(long l) {
        int n = this.botStats.size();
        botStatPoint botStatPoint2 = null;
        for (int i = n - 1; i >= 0; --i) {
            botStatPoint2 = this.botStats.get(i);
            if (botStatPoint2.getTime() == l) {
                return botStatPoint2;
            }
            if (botStatPoint2.getTime() >= l) continue;
            return null;
        }
        return null;
    }

    public long getLastSeenTime() {
        if (this.hasLast()) {
            return this.getLast().getTime();
        }
        return -1000L;
    }

    public double energyDrop() {
        if (this.hasPrev()) {
            return this.getPrev().getEnergy() - this.getLast().getEnergy();
        }
        return 0.0;
    }

    public boolean didItFireABullet(long l) {
        if (l - this.getLastSeenTime() >= 1L) {
            return false;
        }
        boolean bl = true;
        double d = this.energyDrop();
        if (d < 1.0E-6 || 3.0 < d) {
            bl = false;
            return bl;
        }
        bl = true;
        return bl;
    }

    public String getName() {
        return this.name;
    }

    public void setUnLockedStatus(boolean bl) {
        this.targetUnlocked = bl;
    }

    public String format() {
        String string = this.hasPrev() ? "Prev: " + this.getPrev().format() : "Prev: unknown";
        String string2 = this.hasLast() ? "Last: " + this.getLast().format() : "Last: unknown";
        int n = this.botStats.size();
        String string3 = "Target bot name: " + this.getName() + "\n" + string2 + "\n" + string;
        string3 = string3 + "\n stats size " + n;
        return string3;
    }

    public matchedEnds getMatchedEnds() {
        return this._matchedEnds;
    }

    protected LinkedList<Integer> findPatternLength1MatchesList() {
        int n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n2 = this.botStats.size();
        botStatPoint botStatPoint2 = this.botStats.get(n2 - 1);
        for (int i = n = n2 - 2; i >= Math.max(0, n - this.maxDepthOfHistorySearch); --i) {
            botStatPoint botStatPoint3 = this.botStats.get(i);
            if (!botStatPoint3.arePointsOfPathSimilar(botStatPoint2, botStatPoint2, botStatPoint3)) continue;
            linkedList.add(i);
        }
        return linkedList;
    }

    protected void updateEndsOfMatchedSegments() {
        LinkedList<Integer> linkedList;
        int n = this.botStats.size();
        botStatPoint botStatPoint2 = this.botStats.get(n - 1);
        if (this._matchedEnds.size() >= 1) {
            int n2;
            linkedList = new LinkedList();
            LinkedList<Integer> linkedList2 = new LinkedList<Integer>();
            Iterator iterator = this._matchedEnds.getEndsForPatternSizeN(1).iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                botStatPoint botStatPoint3 = this.botStats.get(n2 + 1);
                if (botStatPoint3.arePointsOfPathSimilar(botStatPoint2, botStatPoint2, botStatPoint3)) {
                    linkedList2.add(n2);
                    continue;
                }
                linkedList.add(n2);
            }
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                n2 = (Integer)iterator.next();
                this._matchedEnds.removePoint(n2);
            }
            if (linkedList2.size() >= 1) {
                this._matchedEnds.promoteAndInsert(linkedList2);
            } else if (this._matchedEnds.size() != 0) {
                logger.error("ERROR: this should not happen, matches set should empty");
                logger.error(this._matchedEnds.format());
            }
        }
        linkedList = this.findPatternLength1MatchesList();
        this._matchedEnds.addUniqueOnlyToLowLevel(linkedList);
    }

    public matchedEnds endsOfMatchedSegments(long l, int n) {
        return this.endsOfMatchedSegments(l, this.botStats.size() - 1, n);
    }

    public matchedEnds endsOfMatchedSegments(long l, int n, int n2) {
        long l2 = System.nanoTime();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        matchedEnds matchedEnds2 = new matchedEnds();
        long l3 = this.botStats.size();
        boolean bl = false;
        if (l < 1L) {
            return matchedEnds2;
        }
        int n3 = (int)(l3 - 1L);
        botStatPoint botStatPoint2 = this.botStats.get(n3);
        int n4 = 1;
        int n5 = 0;
        int n6 = n;
        while ((long)n6 >= Math.max(0L, l3 - (long)this.maxDepthOfHistorySearch - 1L)) {
            botStatPoint botStatPoint3 = this.botStats.get(n6);
            if (botStatPoint3.arePointsOfPathSimilar(botStatPoint2, botStatPoint2, botStatPoint3)) {
                linkedList.add(n6);
                if (++n5 > n2) break;
            }
            --n6;
        }
        long l4 = System.nanoTime();
        logger.profiler("For pattern length " + n4 + " find # matches " + linkedList.size() + " in time " + (l4 - l2) + " ns");
        LinkedList<Integer> linkedList2 = linkedList;
        while (linkedList.size() >= 1 && (long)n4 <= l) {
            ++n4;
            l2 = System.nanoTime();
            linkedList2 = linkedList;
            matchedEnds2.add(linkedList2);
            linkedList = new LinkedList();
            for (Integer n7 : linkedList2) {
                botStatPoint botStatPoint4;
                int n8 = n7 - n4 + 1;
                int n9 = n3 - n4 + 1;
                if (n8 < 0 || n9 < 0) {
                    linkedList.remove(n7);
                    continue;
                }
                botStatPoint botStatPoint5 = this.botStats.get(n7);
                botStatPoint botStatPoint6 = this.botStats.get(n8);
                if (!botStatPoint6.arePointsOfPathSimilar(botStatPoint2, botStatPoint4 = this.botStats.get(n9), botStatPoint5)) continue;
                linkedList.add(n7);
            }
            l4 = System.nanoTime();
        }
        --n4;
        return matchedEnds2;
    }

    public LinkedList<Point2D.Double> possiblePositionsAfterTime(long l, long l2, int n) {
        LinkedList<Point2D.Double> linkedList = new LinkedList();
        int n2 = this.botStats.size();
        int n3 = (int)((long)n2 - l - 1L);
        matchedEnds matchedEnds2 = this.endsOfMatchedSegments(l2, n3, n);
        linkedList = this.playForwardList(matchedEnds2, l, this.botStats.getLast());
        return linkedList;
    }

    public LinkedList<Point2D.Double> playForwardTrace(int n, long l) {
        return this.playForwardTrace(n, l, this.botStats.getLast());
    }

    public LinkedList<Point2D.Double> playForwardTrace(int n, long l, botStatPoint botStatPoint2) {
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        for (long i = 1L; i <= l; ++i) {
            Point2D.Double double_ = this.playForward(n, i, botStatPoint2);
            if (double_ == null) continue;
            linkedList.add(double_);
        }
        return linkedList;
    }

    public Point2D.Double playForward(int n, long l, botStatPoint botStatPoint2) {
        Point2D.Double double_ = botStatPoint2.getPosition();
        Point2D.Double double_2 = botStatPoint2.getVelocity();
        double d = botStatPoint2.getSpeed();
        double d2 = botStatPoint2.getHeadingDegrees();
        int n2 = this.botStats.size();
        botStatPoint botStatPoint3 = this.botStats.get(n);
        double d3 = botStatPoint3.getHeadingDegrees();
        Point2D.Double double_3 = botStatPoint3.getPosition();
        int n3 = (int)((long)n + l);
        if (n3 > n2 - 1) {
            return null;
        }
        if (this.botStats.get(n3).getTime() - botStatPoint3.getTime() != l) {
            return null;
        }
        Point2D.Double double_4 = this.botStats.get(n3).getPosition();
        double d4 = double_3.distance(double_4);
        double d5 = double_4.x - double_3.x;
        double d6 = double_4.y - double_3.y;
        double d7 = math.cortesian2game_angles(Math.atan2(d6, d5) * 180.0 / Math.PI) - d3;
        double d8 = d7 + d2;
        d5 = d4 * Math.sin(d8 / 180.0 * Math.PI);
        d6 = d4 * Math.cos(d8 / 180.0 * Math.PI);
        Point2D.Double double_5 = new Point2D.Double(double_.x + d5, double_.y + d6);
        return double_5;
    }

    public LinkedList<Point2D.Double> playForwardList(matchedEnds matchedEnds2, long l, botStatPoint botStatPoint2) {
        LinkedList<Point2D.Double> linkedList = new LinkedList<Point2D.Double>();
        LinkedList<Integer> linkedList2 = matchedEnds2.flatten();
        int n = this.botStats.size();
        int n2 = linkedList2.size();
        if (n2 == 0) {
            return linkedList;
        }
        Point2D.Double double_ = botStatPoint2.getPosition();
        Point2D.Double double_2 = botStatPoint2.getVelocity();
        double d = botStatPoint2.getSpeed();
        double d2 = botStatPoint2.getHeadingDegrees();
        for (int i = 0; i < n2; ++i) {
            int n3 = linkedList2.get(i);
            Point2D.Double double_3 = this.playForward(n3, l, botStatPoint2);
            if (double_3 == null || math.isBotOutOfBorders(double_3)) continue;
            linkedList.add(double_3);
        }
        return linkedList;
    }

    public long guessFactor2itsBin(double d, double d2) {
        return Math.round((d + 1.0) / 2.0 * (d2 - 1.0));
    }

    public int getGuessFactorCount(InfoBot infoBot, double d) {
        int n = (int)this.guessFactor2itsBin(d, this.numGuessFactorBins);
        String string = infoBot.getName();
        if (!this.guessFactorsMap.containsKey(string)) {
            return 0;
        }
        int[] nArray = this.guessFactorsMap.get(string);
        return nArray[n];
    }

    public double getGuessFactorProb(InfoBot infoBot, double d) {
        String string = infoBot.getName();
        if (!this.guessFactorsTotalCounts.containsKey(string)) {
            return 0.0;
        }
        int n = this.getGuessFactorCount(infoBot, d);
        int n2 = this.guessFactorsTotalCounts.get(string);
        return (double)n / (double)n2;
    }

    public double getGuessFactorNormProb(InfoBot infoBot, double d) {
        String string = infoBot.getName();
        if (!this.guessFactorsMaxCounts.containsKey(string)) {
            return 0.0;
        }
        int n = this.getGuessFactorCount(infoBot, d);
        int n2 = this.guessFactorsMaxCounts.get(string);
        return (double)n / (double)n2;
    }

    public void updateHitGuessFactor(InfoBot infoBot, double d) {
        int[] nArray;
        int n = (int)this.guessFactor2itsBin(d, this.numGuessFactorBins);
        String string = infoBot.getName();
        if (!this.guessFactorsMap.containsKey(string)) {
            nArray = new int[this.numGuessFactorBins];
            this.guessFactorsMap.put(string, nArray);
        }
        if (!this.guessFactorsTotalCounts.containsKey(string)) {
            this.guessFactorsTotalCounts.put(string, 0);
        }
        if (!this.guessFactorsMaxCounts.containsKey(string)) {
            this.guessFactorsMaxCounts.put(string, 0);
        }
        nArray = this.guessFactorsMap.get(string);
        nArray[n] = nArray[n] + 1;
        int n2 = this.guessFactorsTotalCounts.get(string);
        this.guessFactorsTotalCounts.put(string, ++n2);
        int n3 = this.guessFactorsMaxCounts.get(string);
        if (nArray[n] > n3) {
            this.guessFactorsMaxCounts.put(string, nArray[n]);
        }
    }

    public String guessFactorBins2string4botName(String string) {
        int[] nArray;
        if (!this.guessFactorsMap.containsKey(string)) {
            nArray = new int[this.numGuessFactorBins];
            this.guessFactorsMap.put(string, nArray);
        }
        nArray = this.guessFactorsMap.get(string);
        String string2 = "";
        for (int i = 0; i < this.numGuessFactorBins; ++i) {
            string2 = string2 + " " + nArray[i] + " ";
        }
        return string2;
    }

    public String guessFactorBins2string(InfoBot infoBot) {
        String string = infoBot.getName();
        return this.guessFactorBins2string4botName(string);
    }

    public void drawLastKnownBotPosition(Graphics2D graphics2D) {
        if (this.hasLast()) {
            double d = 50.0;
            botStatPoint botStatPoint2 = this.getLast();
            graphics.drawSquare(graphics2D, botStatPoint2.getPosition(), d);
        }
    }

    public void drawBotPath(Graphics2D graphics2D) {
        botStatPoint botStatPoint2;
        ListIterator<botStatPoint> listIterator = this.botStats.listIterator(this.botStats.size());
        if (listIterator.hasPrevious()) {
            botStatPoint2 = listIterator.previous();
        } else {
            return;
        }
        while (listIterator.hasPrevious()) {
            botStatPoint botStatPoint3 = listIterator.previous();
            if (botStatPoint2.getTime() <= botStatPoint3.getTime()) {
                return;
            }
            graphics.drawLine(graphics2D, botStatPoint2.getPosition(), botStatPoint3.getPosition());
            botStatPoint2 = botStatPoint3;
        }
    }

    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(255, 255, 0, 128));
        this.drawBotPath(graphics2D);
        this.drawLastKnownBotPosition(graphics2D);
    }
}

