/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import divineomega.guns.Gun;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;

public class VirtualBullet {
    private double velocity;
    private Point2D origin;
    private double heading;
    private long startingTime;
    private double radius;
    private boolean virtualBulletIsDead = false;
    private Point2D bulletPosition;
    private Gun gun;

    public VirtualBullet(Gun gun, double velocity, Point2D origin, double heading, long startingTime) {
        this.gun = gun;
        this.velocity = velocity;
        this.origin = origin;
        this.heading = heading;
        this.startingTime = startingTime;
        this.update(startingTime);
    }

    public void update(long newTime) {
        this.radius = this.velocity * (double)(newTime - this.startingTime);
        this.bulletPosition = DivineBot.project(this.origin, this.heading, this.radius);
        if (DivineBot.enemyRectangle.contains(this.bulletPosition)) {
            this.gun.hits += 1.0;
            this.virtualBulletIsDead = true;
        }
    }

    public void update(long newTime, Point2D enemyPosition) {
        this.update(newTime);
        if ((double)(newTime - this.startingTime) * this.velocity >= this.origin.distance(enemyPosition) + 100.0) {
            this.virtualBulletIsDead = true;
        }
    }

    public boolean isDead() {
        return this.virtualBulletIsDead;
    }

    public void paint(Graphics g, Color color) {
        g.setColor(color);
        double size = 7.0;
        g.drawOval((int)(this.bulletPosition.getX() - size / 2.0), (int)(this.bulletPosition.getY() - size / 2.0), (int)size, (int)size);
        g.drawString(this.gun.name, (int)this.bulletPosition.getX() + 10, (int)this.bulletPosition.getY() + 10);
    }

    public Gun getGun() {
        return this.gun;
    }

    public void markAsDead() {
        this.virtualBulletIsDead = true;
    }

    public Point2D getBulletPosition() {
        return this.bulletPosition;
    }
}

