/*
 * Decompiled with CFR 0.152.
 */
package pulsar.util;

import apv.MovSim;
import apv.MovSimStat;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.gf.AccSegmentation;
import pulsar.gf.Segmentation;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class RobotData {
    public static final int HISTORY_LENGTH = 8;
    public String name;
    public long updateTime = 0;
    public int dataFromRound = -1;
    public double lastFirePower = 2;
    public double lastEnergy = 0.0;
    public double timeSinceStop = 0.0;
    public double velocityBeforeChange = 0.0;
    public boolean isAlive = false;
    public long timeLastFire = 0;
    public long timeLastHit = 0;
    public long timeLastHitUs = 0;
    public int totalMovingForwardHits = 0;
    public int bulletHits = 0;
    public int bulletRangeHits = 0;
    public int roundRamHits = 0;
    public double[] x = new double[8];
    public double[] y = new double[8];
    public double[] velocity = new double[8];
    public double[] heading = new double[8];
    public double[] energy = new double[8];
    public double absBearing;
    private int index = 0;
    private double oldDirection = 1.0;
    public double[] timeSinceDeaccel = new double[8];
    public double[] timeSinceAccel = new double[8];
    public double[] timeSinceVelocityChange = new double[8];
    public double avgabsspeed;
    public double avgabschangehead;
    protected int nAverageSpeedReadings;
    public double avgTimeBetweenStops = Integer.MAX_VALUE;
    protected int nStops = 0;
    public int roundBulletHits = 0;
    public int roundBulletMisses = 0;
    public int totalBulletHits = 0;
    public int totalBulletMisses = 0;
    private Map roundBulletHitsMap = new HashMap();
    private Map roundBulletMissMap = new HashMap();
    private Map totalBulletHitsMap = new HashMap();
    private Map totalBulletMissMap = new HashMap();

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void addBulletHit(String targeting) {
        ++this.roundBulletHits;
        if (targeting != null) {
            this.roundBulletHitsMap.put(targeting, new Integer(this.getRoundBulletHits(targeting) + 1));
        } else {
            System.out.println("Bullet hit with unknown targeting used!");
        }
    }

    public void addBulletMiss(String targeting) {
        ++this.roundBulletMisses;
        if (targeting != null) {
            this.roundBulletMissMap.put(targeting, new Integer(this.getRoundBulletMiss(targeting) + 1));
        } else {
            System.out.println("Bullet miss with unknown targeting used!");
        }
    }

    private int getRoundBulletMiss(String targeting) {
        Integer val = (Integer)this.roundBulletMissMap.get(targeting);
        return val != null ? val : 0;
    }

    private int getRoundBulletHits(String targeting) {
        Integer val = (Integer)this.roundBulletHitsMap.get(targeting);
        return val != null ? val : 0;
    }

    private int getTotalBulletMiss(String targeting) {
        Integer val = (Integer)this.totalBulletMissMap.get(targeting);
        return val != null ? val : 0;
    }

    private int getTotalBulletHits(String targeting) {
        Integer val = (Integer)this.totalBulletHitsMap.get(targeting);
        return val != null ? val : 0;
    }

    public double getCurrentTotalHitRate(String targeting) {
        int totalBulletHits = 0;
        int roundBulletHits = 0;
        totalBulletHits = this.getTotalBulletHits(targeting);
        roundBulletHits = this.getRoundBulletHits(targeting);
        double total = totalBulletHits + this.getTotalBulletMiss(targeting) + roundBulletHits + this.getRoundBulletMiss(targeting);
        if (total == 0.0) {
            return 0.0;
        }
        return (double)(totalBulletHits + roundBulletHits) / total;
    }

    public void reset() {
        String key;
        this.isAlive = false;
        this.timeSinceStop = 0.0;
        this.updateTime = 0;
        this.index = 0;
        this.timeLastFire = 0;
        this.timeLastHit = 0;
        this.timeLastHitUs = 0;
        this.roundRamHits = 0;
        this.totalBulletHits += this.roundBulletHits;
        this.totalBulletMisses += this.roundBulletMisses;
        Iterator iter = this.roundBulletMissMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            this.totalBulletMissMap.put(key, new Integer(this.getTotalBulletMiss(key) + this.getRoundBulletMiss(key)));
        }
        iter = this.roundBulletHitsMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            this.totalBulletHitsMap.put(key, new Integer(this.getTotalBulletHits(key) + this.getRoundBulletHits(key)));
        }
        this.roundBulletHits = 0;
        this.roundBulletMisses = 0;
    }

    public Point2D.Double getLoc(int stepsBack) {
        return new Point2D.Double(this.getValue(this.x, stepsBack), this.getValue(this.y, stepsBack));
    }

    public Point2D.Double getLoc() {
        return this.getLoc(0);
    }

    public double getValue(double[] array) {
        return this.getValue(array, 0);
    }

    public double getValue(double[] array, int stepsBack) {
        return this.getValue(Math.max(this.index - stepsBack, 0), array);
    }

    private double getValue(int index, double[] array) {
        return array[index % 8];
    }

    protected void updateValue(double[] array, double value, int newIndex) {
        if (newIndex > this.index + 1) {
            int steps = newIndex - this.index;
            double totDiff = value - this.getValue(array);
            double linearDiffSegment = totDiff / (double)steps;
            this.updateValue(array, value - linearDiffSegment, newIndex - 1);
        }
        array[newIndex % 8] = value;
    }

    public void update(AdvancedRobot robot) {
        this.name = robot.getName();
        this.dataFromRound = robot.getRoundNum();
        this.isAlive = true;
        this.update(robot.getTime(), robot.getX(), robot.getY(), robot.getVelocity(), robot.getHeadingRadians(), robot.getEnergy());
        this.lastEnergy = robot.getEnergy();
    }

    public void updateFromScan(AdvancedRobot robot, ScannedRobotEvent e) {
        this.name = e.getName();
        this.dataFromRound = robot.getRoundNum();
        this.isAlive = true;
        this.absBearing = (robot.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        double x = robot.getX() + Math.sin(this.absBearing) * e.getDistance();
        double y = robot.getY() + Math.cos(this.absBearing) * e.getDistance();
        double prevVelocity = this.getValue(this.velocity);
        this.update(robot.getTime(), x, y, e.getVelocity(), e.getHeadingRadians(), e.getEnergy());
        double wallDamage = 0.0;
        if (!(Math.abs(e.getVelocity()) != 0.0 || !(Math.abs(prevVelocity) > 2.0) || x >= (double)20 && x <= PulsarMax.field.getMaxX() - (double)20 && y >= (double)20 && !(y > PulsarMax.field.getMaxY() - (double)20))) {
            wallDamage = Math.max(0.0, Math.abs(prevVelocity) / (double)2 - 1.0);
        }
        double changeEnergy = this.lastEnergy - e.getEnergy() - wallDamage;
        this.lastEnergy = e.getEnergy();
        if (changeEnergy > 0.09 && changeEnergy < 3.01) {
            PulsarMax.enemyFireListener.addWave(this, changeEnergy);
        }
    }

    protected void update(long time, double x, double y, double velocity, double heading, double energy) {
        int diff = (int)(time - this.updateTime);
        int newIndex = this.index + diff;
        this.isAlive = true;
        this.updateValue(this.x, x, newIndex);
        this.updateValue(this.y, y, newIndex);
        this.updateValue(this.velocity, velocity, newIndex);
        this.updateValue(this.heading, heading, newIndex);
        this.updateValue(this.energy, energy, newIndex);
        double prevVelocity = this.getValue(this.velocity);
        double speedChange = AccSegmentation.getSpeedChange(velocity, prevVelocity);
        if (Math.abs(speedChange) > 0.5) {
            this.updateValue(this.timeSinceVelocityChange, 0.0, newIndex);
            this.velocityBeforeChange = prevVelocity;
        } else {
            this.updateValue(this.timeSinceVelocityChange, this.getValue(this.timeSinceVelocityChange) + (double)diff, newIndex);
        }
        if (speedChange < -0.5) {
            this.updateValue(this.timeSinceDeaccel, 0.0, newIndex);
        } else {
            this.updateValue(this.timeSinceDeaccel, this.getValue(this.timeSinceDeaccel) + (double)diff, newIndex);
        }
        if (speedChange > 0.5) {
            this.updateValue(this.timeSinceAccel, 0.0, newIndex);
        } else {
            this.updateValue(this.timeSinceAccel, this.getValue(this.timeSinceAccel) + (double)diff, newIndex);
        }
        ++this.nAverageSpeedReadings;
        this.avgabschangehead = Util.getRollingAverage(this.avgabschangehead, Math.abs(heading - this.getValue(this.heading)), Math.min(1000, this.nAverageSpeedReadings), 1.0);
        this.avgabsspeed = Util.getRollingAverage(this.avgabsspeed, Math.abs(velocity), Math.min(1000, this.nAverageSpeedReadings), 1.0);
        if (Math.abs(velocity) >= 0.5) {
            this.timeSinceStop += 1.0;
        } else if (this.timeSinceStop > 0.0) {
            ++this.nStops;
            this.avgTimeBetweenStops = Util.getRollingAverage(this.avgTimeBetweenStops, this.timeSinceStop, Math.min(50, this.nStops), 1.0);
            this.timeSinceStop = 0.0;
        }
        this.index = newIndex;
        this.updateTime = time;
    }

    public double getAbsBearingTo(RobotData robot, int stepsBack) {
        return Util.absbearing(this.getValue(this.x, stepsBack), this.getValue(this.y, stepsBack), robot.getValue(robot.x, stepsBack), robot.getValue(robot.y, stepsBack));
    }

    public double getDistanceTo(RobotData robot, int stepsBack) {
        return Point2D.distance(this.getValue(this.x, stepsBack), this.getValue(this.y, stepsBack), robot.getValue(robot.x, stepsBack), robot.getValue(robot.y, stepsBack));
    }

    public double getAdvancingVelocityRelativeTo(RobotData robot, int stepsBack) {
        return -Math.cos(robot.getValue(this.heading, stepsBack) - robot.getAbsBearingTo(this, stepsBack)) * this.getValue(this.velocity, stepsBack);
    }

    public double getDirectionRelativeTo(RobotData robot, int stepsBack) {
        double lateralVelocity = 1.0;
        int count = 0;
        while ((lateralVelocity = this.getLateralVelocityRelativeTo(robot, stepsBack--)) == 0.0 && ++count < 8) {
        }
        if (lateralVelocity == 0.0) {
            lateralVelocity = this.oldDirection;
        } else {
            this.oldDirection = Util.sign(lateralVelocity);
        }
        return Util.sign(lateralVelocity);
    }

    public double getLateralVelocityRelativeTo(RobotData robot, int stepsBack) {
        double absBearingVal = robot.getAbsBearingTo(this, stepsBack);
        double velocity = this.getValue(this.velocity, stepsBack);
        double heading = this.getValue(this.heading, stepsBack);
        return velocity * Math.sin(heading - absBearingVal);
    }

    public Wave createWave(RobotData firedAt, double firePower, boolean virtual, Map segs) {
        double time;
        Wave wave = new Wave();
        wave.virtual = virtual;
        wave.firePower = firePower;
        int segTime = 0;
        if (this == PulsarMax.robotStats) {
            wave.time = PulsarMax.time - (long)1;
            wave.origin = new Point2D.Double(this.getValue(this.x), this.getValue(this.y));
            wave.locAtFireTime = new Point2D.Double(firedAt.getValue(firedAt.x), firedAt.getValue(firedAt.y));
            time = wave.origin.distance(wave.locAtFireTime) / Util.getBulletSpeed(wave.firePower);
            wave.linearImpact = Util.linearPredict(firedAt.getValue(firedAt.x), firedAt.getValue(firedAt.y), firedAt.getValue(firedAt.heading), firedAt.getValue(firedAt.velocity), (int)Math.round(time));
            wave.firedAtCircleDir = firedAt.getDirectionRelativeTo(this, 0);
            wave.startBearing = firedAt.absBearing;
            if (!virtual) {
                this.lastFirePower = firePower;
                this.timeLastFire = PulsarMax.time;
            }
        } else {
            wave.time = PulsarMax.time - (long)1;
            segTime = 1;
            wave.origin = new Point2D.Double(this.getValue(this.x, 0), this.getValue(this.y, 0));
            wave.locAtFireTime = new Point2D.Double(firedAt.getValue(firedAt.x, segTime), firedAt.getValue(firedAt.y, segTime));
            time = wave.origin.distance(wave.locAtFireTime) / Util.getBulletSpeed(wave.firePower);
            wave.linearImpact = Util.linearPredict(firedAt.getValue(firedAt.x), firedAt.getValue(firedAt.y), firedAt.getValue(firedAt.heading), firedAt.getValue(firedAt.velocity), (int)Math.round(time));
            wave.firedAtCircleDir = firedAt.getDirectionRelativeTo(this, segTime);
            wave.startBearing = Util.absbearing(wave.origin, wave.locAtFireTime);
            if (!virtual) {
                this.lastFirePower = firePower;
                this.timeLastFire = PulsarMax.time - (long)1;
            }
        }
        Iterator iter = segs.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            int[] segVals = this.getSegmentationValues(firedAt, (Segmentation[])segs.get(name), segTime);
            wave.gfIndexes.put(name, segVals);
        }
        return wave;
    }

    private int[] getSegmentationValues(RobotData firedAt, Segmentation[] segmentations, int stepsBack) {
        int[] result = new int[segmentations.length];
        int i = 0;
        while (i < segmentations.length) {
            result[i] = segmentations[i].getIndex(this, firedAt, stepsBack);
            ++i;
        }
        return result;
    }

    public MovSimStat[] predictMovement(int steps) {
        double targetChangeHeading = Util.normalizeRelativeAngle(this.getValue(this.heading) - this.getValue(this.heading, 1));
        if (MovSim.defaultMaxTurnRate - Math.abs(targetChangeHeading) < 0.02) {
            targetChangeHeading *= (double)steps;
        }
        MovSimStat[] pos = MovSim.futurePos(steps, this.getValue(this.x), this.getValue(this.y), this.getValue(this.velocity), 0.0, this.getValue(this.heading), Double.MAX_VALUE, targetChangeHeading, MovSim.defaultMaxTurnRate, PulsarMax.field.getWidth(), PulsarMax.field.getHeight());
        return pos;
    }
}

