/*
 * Decompiled with CFR 0.152.
 */
package origin;

import gun.enemyGunSim;
import java.awt.geom.Point2D;
import origin.BotData;
import origin.Util;
import origin.Wave;
import robocode.util.Utils;
import util.TimedPoint;

public class EnemyWave
extends Wave {
    private static final int NUMGUNS = 3;
    private double bulletPower;
    private double baseRisk = 1000.0;
    private double[] firingAngles;
    private String sourceName;
    private int close = 4;
    private Point2D.Double[] bulletLocationBuffer = new Point2D.Double[3];
    private long bufferTime = -1L;

    public EnemyWave(double cX, double cY, long sT, double bP, BotData self, String sN) {
        super(cX, cY, sT, bP);
        this.sourceName = sN;
        this.bulletPower = bP;
        this.firingAngles = this.generateFiringAngles(new Point2D.Double(cX, cY), self);
    }

    public String getSource() {
        return this.sourceName;
    }

    public double getRisk(TimedPoint point) {
        double x1 = point.getX();
        double y1 = point.getY();
        double bulletRiskFactor = 0.0;
        if (this.bufferTime != point.getTime()) {
            this.updatePredictedBulletLocations(point.getTime() - this.startTime);
        }
        int i = 0;
        while (i < 3) {
            double dist = Point2D.distance(this.bulletLocationBuffer[0].getX(), this.bulletLocationBuffer[0].getY(), x1, y1);
            bulletRiskFactor += 1.0 / (dist * dist);
            ++i;
        }
        return this.baseRisk * bulletRiskFactor;
    }

    public double getDist(double x, double y, long time) {
        double relX = x - this.centerX;
        double relY = y - this.centerY;
        Point2D.Double waveEdge = Util.project(super.getCenter(), Math.atan2(relX, relY), this.bulletVelocity, time - this.startTime);
        return Point2D.distance(waveEdge.getX(), waveEdge.getY(), x, y);
    }

    public Point2D.Double[] getBulletLocations(long time) {
        this.updatePredictedBulletLocations(time - this.startTime);
        return this.bulletLocationBuffer;
    }

    private void updatePredictedBulletLocations(long timeOffset) {
        int i = 0;
        while (i < 3) {
            this.bulletLocationBuffer[i] = Util.project(super.getCenter(), this.firingAngles[i], this.bulletVelocity, timeOffset);
            ++i;
        }
    }

    private double[] generateFiringAngles(Point2D.Double source, BotData target) {
        double[] output = new double[]{Utils.normalRelativeAngle((double)enemyGunSim.headOn(source, target, this.bulletPower)), Utils.normalRelativeAngle((double)enemyGunSim.linearPredictionFire(source, target, this.bulletPower)), Utils.normalRelativeAngle((double)enemyGunSim.constantTurnPredict(source, target, this.bulletPower))};
        return output;
    }

    public void setClose() {
        --this.close;
    }

    public int getClose() {
        return this.close;
    }
}

