/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

import robocode.AdvancedRobot;

public final class Geometry {
    public static double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Geometry.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public static void goTo(AdvancedRobot myBot, double x, double y) {
        double dist = Geometry.getRange(myBot.getX(), myBot.getY(), x, y);
        if (dist != 0.0) {
            dist = 20.0;
        }
        double angle = Math.toDegrees(Geometry.absbearing(myBot.getX(), myBot.getY(), x, y));
        double r = Geometry.turnTo(myBot, angle);
        myBot.setAhead(dist * r);
    }

    public static void goToPoint(AdvancedRobot myBot, double x, double y) {
        double dist = Geometry.getRange(myBot.getX(), myBot.getY(), x, y);
        double angle = Math.toDegrees(Geometry.absbearing(myBot.getX(), myBot.getY(), x, y));
        double r = Geometry.turnTo(myBot, angle);
        myBot.setAhead(dist * r);
    }

    public static int turnTo(AdvancedRobot myBot, double angle) {
        int dir;
        double ang = Geometry.normaliseBearing(myBot.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        myBot.setTurnLeft(ang);
        return dir;
    }

    public static int turnToRads(AdvancedRobot myBot, double angle) {
        int dir;
        double ang = Geometry.normaliseBearing(myBot.getHeadingRadians() - angle);
        if (ang > 0.7853981633974483) {
            ang -= 1.5707963267948966;
            dir = -1;
        } else if (ang < -0.7853981633974483) {
            ang += 1.5707963267948966;
            dir = -1;
        } else {
            dir = 1;
        }
        myBot.setTurnLeftRadians(ang);
        return dir;
    }

    public static double getXCoord(AdvancedRobot myBot, double angle, double dist) {
        return myBot.getX() + Math.sin(angle) * dist;
    }

    public static double getYCoord(AdvancedRobot myBot, double angle, double dist) {
        return myBot.getY() + Math.cos(angle) * dist;
    }

    public static double calcXCoord(double x, double angle, double dist) {
        return x + Math.sin(angle) * dist;
    }

    public static double calcYCoord(double y, double angle, double dist) {
        return y + Math.cos(angle) * dist;
    }
}

