/*
 * Decompiled with CFR 0.152.
 */
package inonit.script.engine;

import inonit.script.runtime.io.Streams;
import inonit.system.Logging;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Code {
    private static final Logging LOG = Logging.get();

    private Code() {
    }

    public static abstract class Loader {
        public static Loader NULL = new Loader(){

            public String toString() {
                return "Code.Loader.NULL";
            }

            @Override
            public Resource getFile(String path) {
                return null;
            }

            @Override
            public Locator getLocator() {
                return null;
            }

            @Override
            public Enumerator getEnumerator() {
                return new Enumerator(){

                    @Override
                    public String[] list(String prefix) {
                        return new String[0];
                    }
                };
            }
        };
        private static final Loader system = new Loader(){

            public String toString() {
                return "Source: system class loader";
            }

            @Override
            public Resource getFile(String path) {
                URL url = ClassLoader.getSystemClassLoader().getResource(path);
                if (url == null) {
                    return null;
                }
                return Resource.create(url);
            }

            @Override
            public Locator getLocator() {
                return null;
            }

            @Override
            public Enumerator getEnumerator() {
                return null;
            }
        };

        public static Loader system(String prefix) {
            return system.child(prefix);
        }

        static Loader create(URL url, Enumerator enumerator) {
            return new UrlBased(url, enumerator);
        }

        static Loader jar(File jar) throws IOException {
            try {
                return Loader.create(jar.toURI().toURL(), Enumerator.zip(jar.getAbsolutePath(), new FileInputStream(jar)));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public static Loader create(File file) {
            try {
                return Loader.create(file.toURI().toURL(), Enumerator.create(file));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public static Loader create(URL url) {
            return Loader.create(url, null);
        }

        public static Loader bitbucketApiVersionOne(URL url) {
            return Loader.create(url, Enumerator.bitbucketApiVersionOne(url));
        }

        public static Loader githubApi(URL url) {
            return Loader.create(url, Enumerator.githubApi(url));
        }

        static Loader create(URLClassLoader parent) {
            List<URL> urls = Arrays.asList(parent.getURLs());
            ArrayList<Loader> sources = new ArrayList<Loader>();
            for (URL url : urls) {
                if (url.getProtocol().equals("file")) {
                    try {
                        File file = new File(url.toURI());
                        if (file.getName().endsWith(".jar")) {
                            sources.add(Loader.zip(file));
                            continue;
                        }
                        sources.add(Loader.create(file));
                        continue;
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                sources.add(Loader.create(url));
            }
            return Loader.create(sources);
        }

        public static Loader zip(File file) {
            try {
                return Loader.zip(file.toString(), new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static Loader zip(Resource file) {
            return Loader.zip(file.toString(), file.getInputStream());
        }

        private static Loader zip(final String name, InputStream stream) {
            try {
                ZipEntry entry;
                ZipInputStream in = new ZipInputStream(stream);
                final HashMap<String, 3> files = new HashMap<String, 3>();
                while ((entry = in.getNextEntry()) != null) {
                    final byte[] bytes = new Streams().readBytes(in, false);
                    final String entryName = entry.getName();
                    Resource f = new Resource(){

                        public String toString() {
                            return this.getClass().getName() + " length=" + bytes.length;
                        }

                        @Override
                        public URI getURI() {
                            LOG.log(Loader.class, Level.FINE, "getURI()", null);
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public String getSourceName() {
                            LOG.log(Loader.class, Level.FINE, "getSourceName()", null);
                            return name + "!" + entryName;
                        }

                        @Override
                        public InputStream getInputStream() {
                            return new ByteArrayInputStream(bytes);
                        }

                        @Override
                        public Long getLength() {
                            return new Long(bytes.length);
                        }

                        @Override
                        public Date getLastModified() {
                            return null;
                        }
                    };
                    files.put(entry.getName(), f);
                }
                final Enumerator enumerator = new Enumerator(){

                    @Override
                    public String[] list(String prefix) {
                        String start = prefix + "/";
                        ArrayList<String> rv = new ArrayList<String>();
                        for (String key : files.keySet()) {
                            String suffix;
                            if (!key.startsWith(start) || key.endsWith("/") || (suffix = key.substring(start.length())).indexOf("/") != -1) continue;
                            rv.add(suffix);
                        }
                        return rv.toArray(new String[0]);
                    }
                };
                return new Loader(){

                    public String toString() {
                        return "Code.Loader zip=" + name;
                    }

                    @Override
                    public Resource getFile(String path) throws IOException {
                        LOG.log(Loader.class, Level.FINE, "getFile(" + path + ")", null);
                        Resource rv = (Resource)files.get(path);
                        LOG.log(Loader.class, Level.FINE, String.valueOf(rv), null);
                        return rv;
                    }

                    @Override
                    public Enumerator getEnumerator() {
                        return enumerator;
                    }

                    @Override
                    public Locator getLocator() {
                        LOG.log(Loader.class, Level.FINE, "getClasses()", null);
                        return null;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static Enumerator enumerator(List<Loader> sources) {
            final ArrayList<Enumerator> enumerators = new ArrayList<Enumerator>();
            for (Loader s : sources) {
                Enumerator e = s.getEnumerator();
                if (e == null) {
                    return null;
                }
                enumerators.add(e);
            }
            return new Enumerator(){

                @Override
                public String[] list(String prefix) {
                    HashSet<String> strings = new HashSet<String>();
                    for (Enumerator e : enumerators) {
                        String[] s = e.list(prefix);
                        if (s == null) continue;
                        for (String string : s) {
                            strings.add(string);
                        }
                    }
                    return strings.toArray(new String[0]);
                }
            };
        }

        public static Loader create(final List<Loader> delegates) {
            final Locator classes = new Locator(){

                @Override
                public URL getResource(String path) {
                    for (Loader delegate : delegates) {
                        Locator c = delegate.getLocator();
                        if (c == null || c.getResource(path) == null) continue;
                        return c.getResource(path);
                    }
                    return null;
                }
            };
            final Enumerator enumerator = Loader.enumerator(delegates);
            return new Loader(){

                public String toString() {
                    String rv = "Code.Loader: [";
                    boolean first = true;
                    for (Loader s : delegates) {
                        if (!first) {
                            rv = rv + ",";
                        } else {
                            first = false;
                        }
                        rv = rv + s.toString();
                    }
                    rv = rv + "]";
                    return rv;
                }

                @Override
                public Resource getFile(String path) throws IOException {
                    for (Loader delegate : delegates) {
                        Resource file = delegate.getFile(path);
                        if (file == null) continue;
                        return file;
                    }
                    return null;
                }

                @Override
                public Locator getLocator() {
                    return classes;
                }

                @Override
                public Enumerator getEnumerator() {
                    return enumerator;
                }
            };
        }

        public abstract Resource getFile(String var1) throws IOException;

        public abstract Enumerator getEnumerator();

        public abstract Locator getLocator();

        private String getChildPrefix(String prefix) {
            if (prefix == null || prefix.length() == 0) {
                return "";
            }
            if (prefix.endsWith("/")) {
                return prefix;
            }
            return prefix + "/";
        }

        public final Loader child(final String prefix) {
            final String prepend = this.getChildPrefix(prefix);
            return new Loader(){

                public String toString() {
                    return Loader.class.getName() + " source=" + Loader.this + " prefix=" + prefix;
                }

                @Override
                public Resource getFile(String path) throws IOException {
                    return Loader.this.getFile(prepend + path);
                }

                @Override
                public Locator getLocator() {
                    final Locator delegate = Loader.this.getLocator();
                    if (delegate == null) {
                        return null;
                    }
                    return new Locator(){

                        @Override
                        public URL getResource(String path) {
                            return delegate.getResource(prepend + path);
                        }
                    };
                }

                @Override
                public Enumerator getEnumerator() {
                    final Enumerator parent = Loader.this.getEnumerator();
                    if (parent != null) {
                        return new Enumerator(){

                            @Override
                            public String[] list(String subprefix) {
                                String sub = subprefix == null ? "" : subprefix;
                                return parent.list(prepend + sub);
                            }
                        };
                    }
                    return null;
                }
            };
        }

        private static class UrlBased
        extends Loader {
            private URL url;
            private Enumerator enumerator;
            private Locator classes;

            UrlBased(URL url, Enumerator enumerator) {
                this.url = url;
                this.enumerator = enumerator;
                final MyUrlClassLoader delegate = new MyUrlClassLoader(url);
                this.classes = new Locator(){

                    @Override
                    public URL getResource(String path) {
                        return delegate.getResource(path);
                    }
                };
            }

            public String toString() {
                return Loader.class.getName() + " url=" + this.url;
            }

            @Override
            public Resource getFile(String path) throws IOException {
                URL url = this.classes.getResource(path);
                if (url == null) {
                    return null;
                }
                return Resource.create(url);
            }

            @Override
            public Enumerator getEnumerator() {
                return this.enumerator;
            }

            @Override
            public Locator getLocator() {
                return this.classes;
            }
        }

        private static class MyUrlClassLoader
        extends URLClassLoader {
            private URL url;

            MyUrlClassLoader(URL url) {
                super(new URL[]{url});
                this.url = url;
            }

            @Override
            public URL findResource(String name) {
                Github github = Github.INSTANCE;
                if (github.hosts(this.url)) {
                    try {
                        URL url = new URL(this.url, name, github.getUrlStreamHandler());
                        final URLConnection connection = url.openConnection();
                        HttpURLConnection h = (HttpURLConnection)connection;
                        try {
                            int code = h.getResponseCode();
                            if (code == 404) {
                                return null;
                            }
                            return new URL(this.url, name, new URLStreamHandler(){

                                @Override
                                protected URLConnection openConnection(URL u) throws IOException {
                                    return connection;
                                }
                            });
                        }
                        catch (IOException e) {
                            try {
                                return null;
                            }
                            catch (IOException e2) {
                                return null;
                            }
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.findResource(name);
            }
        }

        public static abstract class Enumerator {
            static Enumerator create(final File file) {
                return new Enumerator(){

                    private File getDirectory(String prefix) {
                        if (prefix == null) {
                            return file.exists() && file.isDirectory() ? file : null;
                        }
                        File rv = new File(file, prefix);
                        if (rv.isDirectory()) {
                            return rv;
                        }
                        return null;
                    }

                    @Override
                    public String[] list(String prefix) {
                        File dir = this.getDirectory(prefix);
                        if (dir == null) {
                            return null;
                        }
                        File[] files = dir.listFiles();
                        ArrayList<String> rv = new ArrayList<String>();
                        for (File file2 : files) {
                            rv.add(file2.isDirectory() ? file2.getName() + "/" : file2.getName());
                        }
                        return rv.toArray(new String[rv.size()]);
                    }
                };
            }

            static Enumerator bitbucketApiVersionOne(final URL base) {
                return new Enumerator(){

                    @Override
                    public String[] list(String prefix) {
                        try {
                            String line;
                            URL url = prefix == null ? base : new URL(base, prefix);
                            BufferedReader lines = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
                            ArrayList<String> rv = new ArrayList<String>();
                            while ((line = lines.readLine()) != null) {
                                rv.add(line);
                            }
                            return rv.toArray(new String[0]);
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                        catch (FileNotFoundException e) {
                            return null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            static Enumerator githubApi(URL base) {
                String path = base.getPath();
                String[] tokens = path.substring(1).split("\\/");
                final String user = tokens[0];
                final String repo = tokens[1];
                return new Enumerator(){

                    @Override
                    public String[] list(String prefix) {
                        try {
                            String protocol = System.getProperty("jsh.github.api.protocol", "https");
                            URL url = new URL(protocol, "api.github.com", -1, "/repos/" + user + "/" + repo + "/contents/" + prefix, Github.INSTANCE.getUrlStreamHandler());
                            String s = new Streams().readString(url.openConnection().getInputStream());
                            TerribleGithubJsonParser parser = new TerribleGithubJsonParser();
                            TerribleGithubJsonParser.JsonValue value = parser.parse(s);
                            TerribleGithubJsonParser.JsonArrayLiteral items = (TerribleGithubJsonParser.JsonArrayLiteral)value;
                            ArrayList<String> rv = new ArrayList<String>();
                            for (TerribleGithubJsonParser.JsonValue item : items.values()) {
                                TerribleGithubJsonParser.JsonObjectLiteral entry = (TerribleGithubJsonParser.JsonObjectLiteral)item;
                                TerribleGithubJsonParser.JsonPrimitive typeProperty = (TerribleGithubJsonParser.JsonPrimitive)entry.getProperty("type");
                                TerribleGithubJsonParser.JsonPrimitive nameProperty = (TerribleGithubJsonParser.JsonPrimitive)entry.getProperty("name");
                                String type = (String)typeProperty.value();
                                String name = (String)nameProperty.value();
                                if (type.equals("file")) {
                                    rv.add(name);
                                    continue;
                                }
                                if (type.equals("dir")) {
                                    rv.add(name + "/");
                                    continue;
                                }
                                throw new Error("Unexpected type: " + entry);
                            }
                            return rv.toArray(new String[0]);
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                        catch (FileNotFoundException e) {
                            return null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            static Enumerator zip(final String sourceName, InputStream stream) throws IOException {
                ZipEntry entry;
                ZipInputStream in = new ZipInputStream(stream);
                final HashMap<String, 4> files = new HashMap<String, 4>();
                while ((entry = in.getNextEntry()) != null) {
                    final byte[] bytes = new Streams().readBytes(in, false);
                    final String entryName = entry.getName();
                    Resource f = new Resource(){

                        public String toString() {
                            return this.getClass().getName() + " length=" + bytes.length;
                        }

                        @Override
                        public URI getURI() {
                            LOG.log(Loader.class, Level.FINE, "getURI()", null);
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public String getSourceName() {
                            LOG.log(Loader.class, Level.FINE, "getSourceName()", null);
                            return sourceName + "!" + entryName;
                        }

                        @Override
                        public InputStream getInputStream() {
                            return new ByteArrayInputStream(bytes);
                        }

                        @Override
                        public Long getLength() {
                            return new Long(bytes.length);
                        }

                        @Override
                        public Date getLastModified() {
                            return null;
                        }
                    };
                    files.put(entry.getName(), f);
                }
                Enumerator enumerator = new Enumerator(){

                    @Override
                    public String[] list(String prefix) {
                        String start = prefix + "/";
                        ArrayList<String> rv = new ArrayList<String>();
                        for (String key : files.keySet()) {
                            String suffix;
                            if (!key.startsWith(start) || key.endsWith("/") || (suffix = key.substring(start.length())).indexOf("/") != -1) continue;
                            rv.add(suffix);
                        }
                        return rv.toArray(new String[0]);
                    }
                };
                return enumerator;
            }

            public abstract String[] list(String var1);

            private static class TerribleGithubJsonParser {
                private TerribleGithubJsonParser() {
                }

                private String parseStringLiteral(State json) {
                    json.consume("\"");
                    String name = json.until("\"");
                    json.consume(name + "\"");
                    return name;
                }

                private JsonPrimitive parseBoolean(State json) {
                    if (json.startsWith("true")) {
                        json.consume("true");
                        return JsonPrimitive.TRUE;
                    }
                    if (json.startsWith("false")) {
                        json.consume("false");
                        return JsonPrimitive.FALSE;
                    }
                    throw new RuntimeException();
                }

                private JsonNull parseNull(State json) {
                    json.consume("null");
                    return JsonNull.INSTANCE;
                }

                private JsonPrimitive parseNumber(State json) {
                    String s = "";
                    while (json.startsWithDigit()) {
                        s = s + json.consume(1);
                    }
                    return JsonPrimitive.number(Double.parseDouble(s));
                }

                private JsonPrimitive parseString(State json) {
                    String value = this.parseStringLiteral(json);
                    return JsonPrimitive.string(value);
                }

                private JsonProperty parseProperty(State json) {
                    String name = this.parseStringLiteral(json);
                    json.consume(":");
                    JsonValue value = this.parse(json);
                    return new JsonProperty(name, value);
                }

                JsonObjectLiteral parseObject(State json) {
                    json.consume("{");
                    HashMap<String, JsonValue> properties = new HashMap<String, JsonValue>();
                    while (!json.startsWith("}")) {
                        JsonProperty property = this.parseProperty(json);
                        properties.put(property.getName(), property.getValue());
                        if (!json.startsWith(",")) continue;
                        json.consume(",");
                    }
                    json.consume("}");
                    return new JsonObjectLiteral(properties);
                }

                JsonArrayLiteral parseArray(State json) {
                    json.consume("[");
                    ArrayList<JsonValue> rv = new ArrayList<JsonValue>();
                    while (!json.startsWith("]")) {
                        rv.add(this.parse(json));
                        if (!json.startsWith(",")) continue;
                        json.consume(",");
                    }
                    json.consume("]");
                    return new JsonArrayLiteral(rv);
                }

                JsonValue parse(State json) {
                    if (json.startsWith("[")) {
                        return this.parseArray(json);
                    }
                    if (json.startsWith("{")) {
                        return this.parseObject(json);
                    }
                    if (json.startsWith("null")) {
                        return this.parseNull(json);
                    }
                    if (json.startsWith("true") || json.startsWith("false")) {
                        return this.parseBoolean(json);
                    }
                    if (json.startsWithDigit()) {
                        return this.parseNumber(json);
                    }
                    if (json.startsWith("\"")) {
                        return this.parseString(json);
                    }
                    throw new RuntimeException("Cannot parse: " + json);
                }

                JsonValue parse(String json) {
                    return this.parse(new State(json));
                }

                private static class JsonProperty {
                    private String name;
                    private JsonValue value;

                    JsonProperty(String name, JsonValue value) {
                        this.name = name;
                        this.value = value;
                    }

                    String getName() {
                        return this.name;
                    }

                    JsonValue getValue() {
                        return this.value;
                    }
                }

                static class State {
                    private String json;

                    State(String json) {
                        this.json = json;
                    }

                    public String toString() {
                        return "JSON[" + this.json + "]";
                    }

                    boolean startsWith(String prefix) {
                        return this.json.startsWith(prefix);
                    }

                    boolean startsWithDigit() {
                        char first = this.json.charAt(0);
                        return first >= '0' && first <= '9';
                    }

                    String until(String substring) {
                        int rv = this.json.indexOf(substring);
                        if (rv == -1) {
                            throw new Error("Substring not found: " + substring);
                        }
                        return this.json.substring(0, this.json.indexOf(substring));
                    }

                    void consume(String prefix) {
                        if (!this.startsWith(prefix)) {
                            throw new RuntimeException("Does not start with " + prefix + ":" + this.json);
                        }
                        this.json = this.json.substring(prefix.length());
                    }

                    String consume(int count) {
                        String rv = this.json.substring(0, count);
                        this.consume(rv);
                        return rv;
                    }
                }

                static class JsonArrayLiteral
                extends JsonObject {
                    private List<JsonValue> contents;

                    JsonArrayLiteral(List<JsonValue> contents) {
                        this.contents = contents;
                    }

                    public String toString() {
                        return "Array[" + this.contents + "]";
                    }

                    List<JsonValue> values() {
                        return this.contents;
                    }
                }

                static class JsonObjectLiteral
                extends JsonObject {
                    private Map<String, JsonValue> properties;

                    JsonObjectLiteral(Map<String, JsonValue> properties) {
                        this.properties = properties;
                    }

                    public String toString() {
                        return "Object{" + this.properties + "}";
                    }

                    JsonValue getProperty(String name) {
                        return this.properties.get(name);
                    }
                }

                static abstract class JsonObject
                extends JsonValue {
                    JsonObject() {
                    }
                }

                static class JsonPrimitive
                extends JsonValue {
                    static JsonPrimitive TRUE = new JsonPrimitive(true);
                    static JsonPrimitive FALSE = new JsonPrimitive(false);
                    private Object o;

                    static JsonPrimitive string(String s) {
                        return new JsonPrimitive(s);
                    }

                    static JsonPrimitive number(Double d) {
                        return new JsonPrimitive(d);
                    }

                    private JsonPrimitive(Object o) {
                        this.o = o;
                    }

                    private JsonPrimitive(boolean b) {
                        this.o = new Boolean(b);
                    }

                    public String toString() {
                        return String.valueOf(this.o);
                    }

                    Object value() {
                        return this.o;
                    }
                }

                static class JsonNull
                extends JsonValue {
                    static final JsonNull INSTANCE = new JsonNull();

                    JsonNull() {
                    }
                }

                static abstract class JsonValue {
                    JsonValue() {
                    }
                }
            }
        }

        public static abstract class Resource {
            public abstract URI getURI();

            public abstract String getSourceName();

            public abstract InputStream getInputStream();

            public abstract Long getLength();

            public abstract Date getLastModified();

            public final Reader getReader() {
                InputStream in = this.getInputStream();
                if (in == null) {
                    return null;
                }
                return new InputStreamReader(in);
            }

            public static Resource create(final File file) {
                return new Resource(){

                    public String toString() {
                        return file.toString();
                    }

                    @Override
                    public URI getURI() {
                        return URI.create(file);
                    }

                    @Override
                    public String getSourceName() {
                        try {
                            return file.getCanonicalPath();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public Long getLength() {
                        return new Long(file.length());
                    }

                    @Override
                    public Date getLastModified() {
                        return new Date(file.lastModified());
                    }

                    @Override
                    public InputStream getInputStream() {
                        try {
                            return new FileInputStream(file);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            private static Resource create(final URL url, final URLConnection opened) {
                return new Resource(){
                    private URLConnection connection;

                    public String toString() {
                        return url.toString();
                    }

                    private String getSourceName(URL url2) {
                        if (url2.getProtocol().equals("file")) {
                            try {
                                File file = new File(url2.toURI());
                                return file.getCanonicalPath();
                            }
                            catch (URISyntaxException uRISyntaxException) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return url2.toExternalForm();
                    }

                    private java.net.URI toURI(URL url2) {
                        if (url2.getProtocol().equals("file")) {
                            return new File(url2.getFile()).toURI();
                        }
                        try {
                            return url2.toURI();
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    private URLConnection connect() throws IOException {
                        if (this.connection == null) {
                            this.connection = opened != null ? opened : url.openConnection();
                        }
                        return this.connection;
                    }

                    @Override
                    public URI getURI() {
                        return new URI(this.toURI(url));
                    }

                    @Override
                    public String getSourceName() {
                        return this.getSourceName(url);
                    }

                    @Override
                    public InputStream getInputStream() {
                        try {
                            return this.connect().getInputStream();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public Long getLength() {
                        try {
                            int i = this.connect().getContentLength();
                            if (i == -1) {
                                return null;
                            }
                            return i;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public Date getLastModified() {
                        try {
                            long l = this.connect().getLastModified();
                            if (l == -1L) {
                                return null;
                            }
                            return new Date(l);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }

            public static Resource create(URL url) {
                return Resource.create(url, null);
            }

            public static Resource create(final URI uri, final String name, final Long length, final Date modified, final InputStream in) {
                return new Resource(){
                    private byte[] bytes;

                    public String toString() {
                        return "Code.Loader.Resource uri=" + uri.adapt() + " name=" + name + " length=" + length + " modified=" + modified;
                    }

                    @Override
                    public URI getURI() {
                        return uri;
                    }

                    @Override
                    public String getSourceName() {
                        return name;
                    }

                    @Override
                    public Long getLength() {
                        return length;
                    }

                    @Override
                    public Date getLastModified() {
                        return modified;
                    }

                    @Override
                    public InputStream getInputStream() {
                        if (this.bytes == null) {
                            try {
                                this.bytes = new Streams().readBytes(in);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return new ByteArrayInputStream(this.bytes);
                    }
                };
            }
        }

        public static class URI {
            private java.net.URI delegate;

            private static java.net.URI string(String s) {
                try {
                    return new java.net.URI("slime://" + s);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }

            static URI create(java.net.URI delegate) {
                return new URI(delegate);
            }

            public static URI create(URL url) {
                try {
                    return new URI(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }

            public static URI script(String scriptName, String path) {
                return new URI(URI.string("script/" + scriptName.replace("/", "-") + "/" + path));
            }

            public static URI jvm(Class<?> c, String path) {
                return new URI(URI.string("java/" + c.getName() + "/" + path));
            }

            private URI(java.net.URI delegate) {
                this.delegate = delegate;
            }

            public java.net.URI adapt() {
                return this.delegate;
            }

            static URI create(File file) {
                return new URI(file.toURI());
            }
        }

        public static class Github {
            public static final Github INSTANCE = new Github();
            private URLStreamHandler handler = new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    URL withoutStreamHandler = new URL(u.toExternalForm());
                    if (System.getProperty("jsh.github.user") != null) {
                        return Github.openBasicAuthConnection(withoutStreamHandler, System.getProperty("jsh.github.user"), System.getProperty("jsh.github.password"));
                    }
                    return withoutStreamHandler.openConnection();
                }
            };

            private static URLConnection openBasicAuthConnection(URL url, String user, String password) throws IOException {
                URLConnection connection = url.openConnection();
                String authorization = "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes());
                connection.addRequestProperty("Authorization", authorization);
                return connection;
            }

            private Github() {
            }

            public boolean hosts(URL url) {
                if (url.getAuthority() == null) {
                    return false;
                }
                return url.getAuthority().equals("raw.githubusercontent.com") || url.getAuthority().equals("api.github.com");
            }

            public URLStreamHandler getUrlStreamHandler() {
                return this.handler;
            }
        }
    }

    public static abstract class Locator {
        public abstract URL getResource(String var1);
    }
}

