/*
 * Decompiled with CFR 0.152.
 */
package edu.otg.spr;

import java.awt.geom.Point2D;

public class Enemy {
    private String name;
    private Point2D.Double lastPos;
    private Point2D.Double currentPos;
    private Point2D.Double predictedPos;
    private double velocity;
    private double heading;
    private double bearing;
    private long lastScanTime;
    private double dist;
    private long lastScanInterval;
    private double energy;
    private double hitDamage;
    private boolean alive;

    public Enemy(String name) {
        this.name = name;
        this.lastPos = new Point2D.Double();
        this.currentPos = new Point2D.Double();
        this.predictedPos = new Point2D.Double();
        this.alive = true;
    }

    public String getName() {
        return this.name;
    }

    public Point2D.Double getDirectionVector() {
        Point2D.Double res = new Point2D.Double();
        res.x = this.currentPos.x - this.lastPos.x;
        res.y = this.currentPos.y - this.lastPos.y;
        double norm = Math.sqrt(res.x * res.x + res.y * res.y);
        if (norm > 0.0) {
            res.x /= norm;
            res.y /= norm;
        }
        return res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Point2D.Double getLastPos() {
        return this.lastPos;
    }

    public void setLastPos(Point2D.Double lastPos) {
        this.lastPos = lastPos;
    }

    public Point2D.Double getCurrentPos() {
        return this.currentPos;
    }

    public void setCurrentPos(Point2D.Double currentPos) {
        this.lastPos = this.currentPos;
        this.currentPos = currentPos;
    }

    public Point2D.Double getPredictedPos() {
        return this.predictedPos;
    }

    public void setPredictedPos(Point2D.Double predictedPos) {
        this.predictedPos = predictedPos;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public long getLastScanTime() {
        return this.lastScanTime;
    }

    public void setLastScanTime(long lastScanTime) {
        this.lastScanInterval = this.lastScanTime - lastScanTime;
        this.lastScanTime = lastScanTime;
    }

    public double getDist() {
        return this.dist;
    }

    public void setDist(double dist) {
        this.dist = dist;
    }

    public long getLastScanInterval() {
        return this.lastScanInterval;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public double getHitDamage() {
        return this.hitDamage;
    }

    public void setHitDamage(double hitDamage) {
        this.hitDamage = hitDamage;
    }

    public double getBearing() {
        return this.bearing;
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public Point2D.Double getVelocityVector() {
        Point2D.Double vel = new Point2D.Double();
        vel.setLocation(Math.sin(Math.toRadians(this.getHeading())) * this.getVelocity(), Math.cos(Math.toRadians(this.getHeading())) * this.getVelocity());
        return vel;
    }
}

