/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.CircularObuf;
import et.Enemy;
import et.Location;
import et.Predator;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import robocode.ScannedRobotEvent;

public final class EnemyMap
extends ArrayList {
    public HashMap theMap;
    private double maxHitsOnMe = 1.0;
    private static Predator thePredator;
    private CircularObuf hitMeBuf;

    public EnemyMap(Predator predator) {
        super(predator.getOthers());
        this.theMap = new HashMap(predator.getOthers());
        thePredator = predator;
        this.hitMeBuf = new CircularObuf(4);
    }

    public final Enemy get(String string) {
        return (Enemy)this.theMap.get(string);
    }

    public final void setDead(String string) {
        ListIterator listIterator = ((AbstractList)this).listIterator();
        while (listIterator.hasNext()) {
            Enemy enemy = (Enemy)listIterator.next();
            if (enemy == null || !enemy.getName().equals(string)) continue;
            enemy.reset(this.maxHitsOnMe);
            listIterator.remove();
        }
    }

    public void reset() {
        this.clear();
        Iterator iterator = this.theMap.values().iterator();
        while (iterator.hasNext()) {
            Enemy enemy = (Enemy)iterator.next();
            if (enemy == null) continue;
            if (enemy.getHitsOnMe() > this.maxHitsOnMe) {
                this.maxHitsOnMe = enemy.getHitsOnMe();
            }
            enemy.reset(this.maxHitsOnMe);
            this.add(enemy);
        }
        int n = 0;
        while (n < this.hitMeBuf.size()) {
            this.hitMeBuf.put(null, 0L);
            ++n;
        }
    }

    public final void update(ScannedRobotEvent scannedRobotEvent) {
        if (!this.theMap.containsKey(scannedRobotEvent.getName())) {
            Enemy enemy = new Enemy(scannedRobotEvent, thePredator);
            this.theMap.put(scannedRobotEvent.getName(), enemy);
            this.add(enemy);
        } else if ((double)scannedRobotEvent.getTime() >= this.get(scannedRobotEvent.getName()).getUpdateTime()) {
            this.get(scannedRobotEvent.getName()).setInfo(scannedRobotEvent);
        }
    }

    public Enemy getNearestEnemy(boolean bl) {
        return this.getNearestEnemy(thePredator.getPosition(), bl);
    }

    public Enemy getNearestEnemy(Location location, boolean bl) {
        Enemy enemy = null;
        double d = Double.POSITIVE_INFINITY;
        ListIterator listIterator = ((AbstractList)this).listIterator();
        while (listIterator.hasNext()) {
            double d2;
            Enemy enemy2 = (Enemy)listIterator.next();
            if (enemy2 == null || !enemy2.isUpdated() || bl && enemy2.isRammable() || !((d2 = enemy2.distance(location)) < d)) continue;
            enemy = enemy2;
            d = d2;
        }
        return enemy;
    }

    public final void setFiredAt(String string, double d) {
        if (this.theMap.containsKey(string)) {
            this.get(string).setFiredAt(d);
        }
    }

    public final void setHit(String string, double d, double d2) {
        if (this.theMap.containsKey(string)) {
            this.get(string).setHit(d, d2);
        }
    }

    public final void setHitMe(String string, double d) {
        if (this.theMap.containsKey(string)) {
            this.get(string).setHitMe(d);
            this.hitMeBuf.put(string, thePredator.getTime());
        }
    }

    public final void updateKillers() {
        Enemy enemy = this.get((String)this.hitMeBuf.get(0));
    }

    public void printStats(PrintStream printStream) {
        printStream.println("Target analysis:");
        Iterator iterator = this.theMap.entrySet().iterator();
        printStream.println("NAME                   HITS    THREAT    aTF  ");
        printStream.println("----------------------------------------------");
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Enemy enemy = (Enemy)entry.getValue();
            if (enemy == null) continue;
            String string = enemy.getName();
            if (string.length() > 23) {
                string = string.substring(0, 19) + "..";
            }
            String string2 = string + ":";
            int n = 0;
            while (n < 22 - string.length()) {
                string2 = string2 + " ";
                ++n;
            }
            string2 = string2 + enemy.getStats();
            printStream.println(string2);
        }
    }
}

