/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.malinkody;

import java.awt.Color;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class DestrobotMalin
extends Robot {
    private double headingToCorner;
    private double headingToClosestCorner;
    private double distanceToWall;
    private double bearingToClosestWall;
    private double distanceToEnemy;
    private int count;
    private boolean secondMode;
    private boolean thirdMode;
    private boolean moveTowardEnemyStarted;
    private int turnCount;
    private boolean hitWallInThirdMode;
    private double thirdModeCount;
    private double bearingToWall;
    private String robotName;

    public void run() {
        this.count = 0;
        this.turnCount = 0;
        this.secondMode = false;
        this.thirdMode = false;
        this.moveTowardEnemyStarted = false;
        this.hitWallInThirdMode = false;
        this.thirdModeCount = 0.0;
        this.robotName = null;
        this.setColors(new Color(13, 51, 91), Color.white, Color.orange);
        while (true) {
            if (this.count == 4 && this.getOthers() == 1) {
                this.secondMode();
            }
            if (this.getOthers() > 1 && this.thirdModeCount == 0.0) {
                this.thirdMode();
            }
            this.setBodyColor(new Color(13, 51, 91));
            if (this.getDistanceToWall() < 200.0) {
                this.onMinWallDistance();
            }
            this.ahead(150.0);
            ++this.count;
        }
    }

    public void secondMode() {
        this.setBodyColor(new Color(67, 84, 73));
        this.secondMode = true;
        while (true) {
            if (this.turnCount > 4) break;
            this.moveGun(0.0);
            this.ahead(10000.0);
        }
        this.endOfMode();
    }

    public void thirdMode() {
        this.setBodyColor(new Color(169, 47, 23));
        this.thirdMode = true;
        this.thirdModeCount += 1.0;
        this.turnRight(this.getBearingToWall());
        while (true) {
            if (this.hitWallInThirdMode) break;
            this.moveGun(0.0);
            this.ahead(10000.0);
        }
        this.thirdMode = false;
        this.secondMode();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.count = 0;
        this.setBulletColor(this.getRandomColor());
        this.distanceToEnemy = e.getDistance();
        if (!this.secondMode && !this.thirdMode) {
            this.distantFire(e);
        } else {
            this.fire(3.0);
        }
        this.scan();
    }

    public void onHitRobot(HitRobotEvent e) {
        if (!this.thirdMode) {
            this.fireOnHit(e);
        } else {
            this.back(50.0);
            this.turnRight(this.getBearingToClosestWall());
        }
    }

    public void onWin(WinEvent e) {
        this.setBodyColor(new Color(240, 48, 79));
        this.turnRadarRight(3600.0);
    }

    public void fireOnHit(HitRobotEvent e) {
        double gunAimingAngle;
        if (this.secondMode) {
            this.robotName = e.getName();
        }
        if ((gunAimingAngle = this.getGunAimingAngle(this.getHeading(), e.getBearing(), this.getGunHeading())) != 0.0 || gunAimingAngle != 360.0) {
            if (gunAimingAngle < 360.0) {
                this.turnGunRight(gunAimingAngle);
            } else {
                this.turnGunRight(gunAimingAngle - 360.0);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.secondMode && this.robotName != null && this.robotName.equals(e.getName())) {
            this.robotName = null;
            this.moveGun(0.0);
            this.scan();
        }
    }

    public double getGunAimingAngle(double robotHeading, double robotBearing, double gunHeading) {
        return robotHeading + robotBearing - gunHeading;
    }

    public double getDistanceToEnemy() {
        return this.distanceToEnemy;
    }

    public void moveTowardEnemy(ScannedRobotEvent e) {
        this.turnRight(e.getBearing());
        this.ahead(e.getDistance() / 3.0);
    }

    public void distantFire(ScannedRobotEvent e) {
        if (e.getDistance() < 800.0) {
            double firePower = (800.0 - e.getDistance()) / 150.0;
            this.fire(firePower);
        }
    }

    public Color getRandomColor() {
        return new Color(new Double(255.0 * Math.random()).intValue(), new Double(255.0 * Math.random()).intValue(), new Double(255.0 * Math.random()).intValue());
    }

    public void onMinWallDistance() {
        this.stop();
        double aW = this.getBearingToClosestWall();
        double aH = this.getHeading();
        this.nearWallMovement(aW, aH);
        this.resume();
    }

    public void onHitWall(HitWallEvent e) {
        this.stop();
        if (this.secondMode) {
            ++this.turnCount;
        }
        if (this.thirdMode) {
            this.hitWallInThirdMode = true;
        }
        double aW = e.getBearing();
        double aH = this.getHeading();
        this.nearWallMovement(aW, aH);
        this.resume();
    }

    public void nearWallMovement(double aW, double aH) {
        if (!(aW != 90.0 && aW != 0.0 || aH % 90.0 != 0.0 && aH != 0.0)) {
            this.turnLeft(90.0);
            this.moveGunLeftNearWall();
        } else if (aW == -90.0 && (aH % 90.0 == 0.0 || aH == 0.0)) {
            this.turnRight(90.0);
            this.moveGunRightNearWall();
        } else if (90.0 > aW && aW > 0.0) {
            this.turnLeft(90.0 - aW);
            this.moveGunLeftNearWall();
        } else {
            this.turnRight(90.0 - (0.0 - aW));
            this.moveGunRightNearWall();
        }
    }

    public void endOfMode() {
        this.count = 0;
        this.turnCount = 0;
        this.secondMode = false;
        this.thirdMode = false;
        this.moveTowardEnemyStarted = false;
        double aW = this.getBearingToClosestWall();
        double aH = this.getHeading();
        if (!(aW != 90.0 && aW != 0.0 || aH % 90.0 != 0.0 && aH != 0.0)) {
            this.moveGunLeftNearWall();
        } else if (aW == -90.0 && (aH % 90.0 == 0.0 || aH == 0.0)) {
            this.moveGunRightNearWall();
        } else if (90.0 > aW && aW > 0.0) {
            this.moveGunLeftNearWall();
        } else {
            this.moveGunRightNearWall();
        }
    }

    public void moveGunLeftNearWall() {
        if (!this.secondMode) {
            this.moveGun(-90.0);
        }
    }

    public void moveGunRightNearWall() {
        if (!this.secondMode) {
            this.moveGun(90.0);
        }
    }

    public void moveGun(double bearing) {
        double gunAimingAngle = this.getGunAimingAngle(this.getHeading(), bearing, this.getGunHeading());
        if (gunAimingAngle != 0.0 || gunAimingAngle != 360.0) {
            if (gunAimingAngle < 360.0) {
                this.turnGunRight(gunAimingAngle);
            } else {
                this.turnGunRight(gunAimingAngle - 360.0);
            }
        }
    }

    public double getHeadingToCorner() {
        double Y = this.getBattleFieldHeight();
        double X = this.getBattleFieldWidth();
        double x = this.getX();
        double y = this.getY();
        double aH = this.getHeading();
        double aC = 0.0 <= aH && aH < 90.0 ? Math.toDegrees(Math.acos((Y - y) / Math.sqrt(Math.pow(X - x, 2.0) + Math.pow(Y - y, 2.0)))) : (90.0 <= aH && aH < 180.0 ? Math.toDegrees(Math.acos((X - x) / Math.sqrt(Math.pow(y, 2.0) + Math.pow(X - x, 2.0)))) + 90.0 : (180.0 <= aH && aH < 270.0 ? Math.toDegrees(Math.acos(y / Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)))) + 180.0 : Math.toDegrees(Math.acos(x / Math.sqrt(Math.pow(x, 2.0) + Math.pow(Y - y, 2.0)))) + 270.0));
        this.headingToCorner = aC;
        return this.headingToCorner;
    }

    public double getHeadingToClosestCorner() {
        return this.headingToClosestCorner;
    }

    public double getDistanceToWall() {
        double Y = this.getBattleFieldHeight();
        double X = this.getBattleFieldWidth();
        double x = this.getX();
        double y = this.getY();
        double aH = this.getHeading();
        double aC = this.getHeadingToCorner();
        double z = 0.0 <= aH && aH < 90.0 ? (aH <= aC ? (Y - y) / Math.cos(aH) : (X - x) / Math.sin(aH)) : (90.0 <= aH && aH < 180.0 ? (aH <= aC ? (X - x) / Math.cos(aH - 90.0) : y / Math.sin(aH - 90.0)) : (180.0 <= aH && aH < 270.0 ? (aH <= aC ? y / Math.cos(aH - 180.0) : x / Math.sin(aH - 180.0)) : (aH <= aC ? x / Math.cos(aH - 270.0) : (Y - y) / Math.sin(aH - 270.0))));
        this.distanceToWall = z;
        return this.distanceToWall;
    }

    public double getBearingToClosestWall() {
        double z = this.getDistanceToWall();
        double aH = this.getHeading();
        double aW = 0.0 <= aH && aH < 90.0 ? (z * Math.cos(aH) < z * Math.sin(aH) ? 0.0 - aH : 90.0 - aH) : (90.0 <= aH && aH < 180.0 ? (z * Math.cos(aH - 90.0) < z * Math.sin(aH - 90.0) ? 0.0 - (aH - 90.0) : 180.0 - aH) : (180.0 <= aH && aH < 270.0 ? (z * Math.cos(aH - 180.0) < z * Math.sin(aH - 180.0) ? 0.0 - (aH - 180.0) : 270.0 - aH) : (z * Math.cos(aH - 270.0) < z * Math.sin(aH) - 270.0 ? 0.0 - (aH - 270.0) : 360.0 - aH)));
        this.bearingToClosestWall = aW;
        return this.bearingToClosestWall;
    }

    public double getBearingToWall() {
        double Y = this.getBattleFieldHeight();
        double X = this.getBattleFieldWidth();
        double x = this.getX();
        double y = this.getY();
        double aH = this.getHeading();
        double aW = Y - y < X - x && Y - y < y && Y - y < x ? this.calculateWallBearing(aH) : (X - x < y && X - x < x && X - x < Y - y ? this.calculateWallBearing(aH - 90.0) : (y < x && y < Y - y && y < X - x ? this.calculateWallBearing(aH - 180.0) : this.calculateWallBearing(aH - 270.0)));
        this.bearingToWall = aW;
        return this.bearingToWall;
    }

    public double calculateWallBearing(double headingToBearing) {
        double aAW = headingToBearing;
        double aW = 0.0 - aAW;
        if (aW < -180.0) {
            aW = 360.0 - aAW;
        }
        return aW;
    }
}

