/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.BasicWave;
import Krabb.sliNk.DataHandling;
import Krabb.sliNk.Garm;
import Krabb.sliNk.MovementStatistics;
import Krabb.sliNk.MyBullet;
import Krabb.sliNk.MyDAArray;
import Krabb.sliNk.MyIAArray;
import java.awt.Graphics2D;

abstract class StaticMovementStatistics
extends MovementStatistics {
    int bins_number;
    MyDAArray stats;
    MyIAArray hits;
    MyDAArray rating;
    int segments_number;
    double dept;
    int gf_type;
    double weight_real;
    double weight_virtual;
    private int lastbin;

    StaticMovementStatistics() {
        this.lastbin = (int)((double)(this.bins_number - 1) / 2.0);
    }

    void newHit(MyBullet bullet, int enemy) {
        boolean alighned;
        double weight = bullet.virtual ? this.weight_virtual : this.weight_real;
        double[] bins = bullet.bins[enemy][this.statistics_this];
        int[] this_hits = bullet.hits[enemy][this.statistics_this];
        double[] this_rating = bullet.rating[enemy][this.statistics_this];
        int i = 0;
        while (i < this.bins_number) {
            if (!bullet.hits_updated[enemy][this.statistics_this][i]) {
                bins[i] = DataHandling.rollingAvg(bins[i], 0.0, Math.min(this.dept, (double)(this_hits[0] + 1)), weight);
            }
            ++i;
        }
        double hitangle_relative = bullet.heading_desired[enemy][this.statistics_this] - bullet.gf_null_angle[enemy];
        boolean bl = alighned = Math.abs(bullet.heading - bullet.heading_desired[enemy][this.statistics_this]) < Math.PI / 360;
        if (hitangle_relative >= bullet.gf_hit_angles[enemy][0] && hitangle_relative <= bullet.gf_hit_angles[enemy][1]) {
            weight = alighned && !bullet.virtual ? 5.0 : (!bullet.virtual ? 2.0 : 1.0);
            this.buffer_rating = DataHandling.rollingAvg(this.buffer_rating, 1.0, Math.min(this.shots, 99999), weight);
            this_rating[0] = DataHandling.rollingAvg(this_rating[0], 1.0, Math.min(this_hits[0], 99999), weight);
        } else {
            weight = alighned && !bullet.virtual ? 5.0 : (!bullet.virtual ? 3.0 : 2.0);
            this.buffer_rating = DataHandling.rollingAvg(this.buffer_rating, 0.0, Math.min(this.shots, 99999), weight);
            this_rating[0] = DataHandling.rollingAvg(this_rating[0], 0.0, Math.min(this_hits[0], 99999), weight);
        }
        this_hits[0] = this_hits[0] + 1;
        ++this.shots;
    }

    public void newHitareaUpdate(MyBullet bullet, int enemy) {
        double[][] gf_hit = bullet.getHitGFs(enemy);
        double bin0 = DataHandling.getBin(gf_hit[this.gf_type][0], this.bins_number);
        double bin1 = DataHandling.getBin(gf_hit[this.gf_type][1], this.bins_number);
        double bin_min = Math.min(bin0, bin1);
        double bin_max = Math.max(bin0, bin1);
        int[] this_hits = bullet.hits[enemy][this.statistics_this];
        double[] bins = bullet.bins[enemy][this.statistics_this];
        double weight = bullet.virtual ? this.weight_virtual : this.weight_real;
        int i = 0;
        while (i < this.bins_number) {
            if (bin_min != bin_max && (double)i >= bin_min && (double)i <= bin_max && !bullet.hits_updated[enemy][this.statistics_this][i]) {
                bins[i] = DataHandling.rollingAvg(bins[i], 1.0, Math.min(this.dept, (double)(this_hits[0] + 1)), weight);
                bullet.hits_updated[enemy][this.statistics_this][i] = true;
            }
            ++i;
        }
    }

    double getBestAlpha(MyBullet bullet, int enemy, double gun_angle, double gun_maxTurn_angle) {
        int bin_best = this.getBestBin(bullet, enemy, gun_angle, gun_maxTurn_angle);
        double gf_best = DataHandling.convertBin2GF(bin_best, this.bins_number);
        int dir = MyBullet.getDir(gf_best *= (double)bullet.direction_start[enemy]);
        double angle_best = gf_best * bullet.gf_max_angles[enemy][this.gf_type][dir];
        return bullet.gf_null_angle[enemy] + angle_best;
    }

    private int getBestBin(MyBullet bullet, int enemy, double gun_angle, double gun_maxTurn_angle) {
        double[] gf_max = new double[2];
        gf_max[1] = this.convertAngle2GF(bullet.gf_max_angles[enemy][2][1], bullet, enemy);
        gf_max[0] = this.convertAngle2GF(-bullet.gf_max_angles[enemy][2][0], bullet, enemy);
        int bin_tmp1 = DataHandling.getBin(gf_max[1], this.bins_number);
        int bin_tmp2 = DataHandling.getBin(gf_max[0], this.bins_number);
        int bin_min = Math.min(bin_tmp1, bin_tmp2);
        int bin_max = Math.max(bin_tmp1, bin_tmp2);
        double[][] x = bullet.bins_factored[enemy];
        double[] y = bullet.bins_factored[enemy][this.statistics_this];
        double z = bullet.bins_factored[enemy][this.statistics_this][0];
        int bin_best = DataHandling.getMaxIndex(bullet.bins_factored[enemy][this.statistics_this], 0.0, bin_min, bin_max);
        if (bin_best == -1) {
            return Math.max(Math.min(this.lastbin, bin_max), bin_min);
        }
        gf_max[1] = this.convertAngle2GF(bullet.gf_max_angles[enemy][1][1], bullet, enemy);
        gf_max[0] = this.convertAngle2GF(-bullet.gf_max_angles[enemy][1][0], bullet, enemy);
        bin_tmp1 = DataHandling.getBin(gf_max[1], this.bins_number);
        bin_tmp2 = DataHandling.getBin(gf_max[0], this.bins_number);
        bin_min = Math.min(bin_tmp1, bin_tmp2);
        bin_max = Math.max(bin_tmp1, bin_tmp2);
        this.lastbin = bin_best = Math.max(bin_min, Math.min(bin_max, bin_best));
        return bin_best;
    }

    private double convertAngle2GF(double angle_delta, MyBullet bullet, int enemy) {
        int dir = BasicWave.getDir(angle_delta);
        return angle_delta / bullet.gf_max_angles[enemy][this.gf_type][dir] * (double)bullet.direction_start[enemy];
    }

    public double getRatingFactor(int shots) {
        if (this.dept <= 5.0) {
            return Math.min((double)shots / 5.0, 1.0);
        }
        return Math.min((double)shots / 10.0, 1.0);
    }

    public int[] getHits(MyBullet bullet, int enemy) {
        int[] segments = this.getSegmentationValues(bullet, enemy);
        return this.hits.getVertex(segments);
    }

    public double[] getBins(MyBullet bullet, int enemy) {
        int[] segments = this.getSegmentationValues(bullet, enemy);
        return this.stats.getVertex(segments);
    }

    public double[] getRating(MyBullet bullet, int enemy) {
        int[] segments = this.getSegmentationValues(bullet, enemy);
        return this.rating.getVertex(segments);
    }

    public void onPaint(Graphics2D g, Garm robot) {
    }
}

