/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import dmh.robocode.bullet.DangerousBullet;
import dmh.robocode.bullet.PerfectSimulatedBullet;
import dmh.robocode.data.AverageLocation;
import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.data.RoundSummary;
import dmh.robocode.data.ShotAtEnemy;
import dmh.robocode.data.ShotByEnemy;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.enemy.EnemySet;
import dmh.robocode.gunner.GunnerCommand;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.gunner.enemy.EnemyShootingAtUsStrategy;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.radar.RadarCommand;
import dmh.robocode.simulate.SimulateableRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public abstract class CommandBasedRobot
extends AdvancedRobot
implements SimulateableRobot {
    private static double myAverageLocationWeightingFactor = 1.05;
    private static boolean displayFinalDebugStats = true;
    protected NavigatorCommand navigatorCommand;
    protected RadarCommand radarCommand;
    protected GunnerCommand gunnerCommand;
    protected static EnemySet enemies = new EnemySet();
    private boolean rammedEnemy = false;
    private boolean hitByBullet = false;
    private HashMap<Bullet, ShotAtEnemy> liveShotsAtEnemy;
    private boolean justFired;
    private List<DangerousBullet> dangerousBullets;
    private List<PerfectSimulatedBullet> perfectSimulatedBullets;
    private Location myLocation;
    private int gunNotFiredPeriod;
    private AverageLocation averageLocation;
    boolean usedFilesInThisRound = false;
    private static List<RoundSummary> roundSummaries = new LinkedList<RoundSummary>();
    private RoundSummary roundSummary;

    protected void doNotDisplayFinalDebugStats() {
        displayFinalDebugStats = false;
    }

    @Override
    public Location getLocation() {
        return this.myLocation;
    }

    public int getGunNotFiredPeriod() {
        return this.gunNotFiredPeriod;
    }

    public final boolean getHitByBullet() {
        return this.hitByBullet;
    }

    public final boolean getRammedEnemy() {
        return this.rammedEnemy;
    }

    public final EnemySet getEnemies() {
        return enemies;
    }

    public final boolean getJustFired() {
        return this.justFired;
    }

    List<DangerousBullet> getDangerousBullets() {
        return this.dangerousBullets;
    }

    public List<PerfectSimulatedBullet> getPerfectSimulatedBullets() {
        return this.perfectSimulatedBullets;
    }

    public void onHitWall(HitWallEvent event) {
        this.navigatorCommand.reverseDirection();
    }

    public void onRobotDeath(RobotDeathEvent event) {
        enemies.getEnemy(event.getName()).processRobotDeathEvent(event.getName());
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.myLocation = new Location(this.getX(), this.getY());
        EnemyRobot enemy = enemies.getEnemy(event.getName());
        if (!event.getName().equals(this.getName())) {
            double energyChange;
            RadarObservation previousObservation = enemy.getLatestRadarObservation();
            RadarObservation radarObservation = new RadarObservation(event, this.myLocation, this.getHeading(), previousObservation);
            enemy.processScannedRobotEvent(event.getName(), radarObservation);
            if (previousObservation != null && previousObservation.getTimeSeen() == radarObservation.getTimeSeen() - 1L && (energyChange = radarObservation.getEnergy() - previousObservation.getEnergy()) < 0.0 && energyChange >= -3.0) {
                this.onEnemyHasFired(enemy, -energyChange);
            }
            if (enemy.getShootingAtUsStrategies().isEmpty()) {
                this.setupEnemyStrategies(enemy);
                this.loadEnemyStatsFromDataFile(enemy);
            }
        } else {
            System.out.println("****************** GOTCHA - RECEIVED SCANNED EVENT FOR MYSELF!!! ******************");
        }
    }

    public void onEnemyHasFired(EnemyRobot enemy, double bulletPower) {
        double likelyToBeAimingForUs = this.getEnemyLikelyToBeAimingForUs(enemy);
        for (EnemyShootingAtUsStrategy strategy : enemy.getShootingAtUsStrategies()) {
            this.dangerousBullets.add(strategy.getDangerousBulletFiredNow(bulletPower, likelyToBeAimingForUs));
        }
        enemy.hasJustFired(bulletPower, this.getTime());
    }

    public double getEnemyLikelyToBeAimingForUs(EnemyRobot enemy) {
        return 100 / this.getOthers();
    }

    public void onHitRobot(HitRobotEvent event) {
        this.rammedEnemy = true;
        if (event.isMyFault()) {
            this.navigatorCommand.reverseDirection();
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.hitByBullet = true;
        EnemyRobot enemy = enemies.getEnemy(event.getName());
        DangerousBullet whatHitUs = null;
        double hittingDistance = 0.0;
        boolean wasClearHit = false;
        double marginForError = Math.max(this.getWidth(), this.getHeight());
        for (DangerousBullet bullet : this.getDangerousBullets()) {
            if (!bullet.isPossibleLocation(this.myLocation, this.getTime(), event.getPower(), marginForError, enemy)) continue;
            double distanceFromUs = Geometry.getDistanceBetweenLocations(bullet.getLocationAtTime(this.getTime()), this.myLocation);
            if (whatHitUs == null || distanceFromUs < hittingDistance) {
                whatHitUs = bullet;
                hittingDistance = distanceFromUs;
            }
            if (Geometry.getDistanceBetweenLocations(this.myLocation, bullet.getFiredFromLocation()) > 200.0) {
                if (distanceFromUs <= Math.max(this.getWidth(), this.getHeight())) {
                    bullet.getShootingStrategy().informHit();
                    wasClearHit = true;
                } else if (distanceFromUs <= 2.0 * Math.max(this.getWidth(), this.getHeight())) {
                    bullet.getShootingStrategy().informNearMiss();
                } else {
                    bullet.getShootingStrategy().informMiss();
                }
            }
            bullet.getShootingStrategy().informHitDetails(this.myLocation, bullet, this.getTime());
        }
        if (whatHitUs != null) {
            if (wasClearHit) {
                whatHitUs.getShootingStrategy().informBestHit();
            }
            this.dangerousBullets.remove(whatHitUs);
        }
        ShotByEnemy shotDetails = new ShotByEnemy(this, enemy, event);
        enemy.recordEnemyHitUs(shotDetails, wasClearHit);
        this.roundSummary.gotHit(Rules.getBulletDamage((double)event.getBullet().getPower()));
    }

    public void onBulletHit(BulletHitEvent event) {
        ShotAtEnemy myShot = this.liveShotsAtEnemy.get(event.getBullet());
        if (myShot != null) {
            EnemyRobot intendedTarget = myShot.getEnemy();
            if (event.getName().equals(intendedTarget.getName())) {
                myShot.setStatus(ShotAtEnemy.ShotStatus.HIT_TARGET);
            } else {
                myShot.setStatus(ShotAtEnemy.ShotStatus.HIT_OTHER);
            }
            this.liveShotsAtEnemy.remove(event.getBullet());
            this.gunnerCommand.hitEnemy(enemies.getEnemy(event.getName()));
        } else {
            this.panic("OOOOPS - No such shot!!!!");
        }
        if (event.getEnergy() <= 0.0) {
            this.roundSummary.killedRobot();
        }
        this.roundSummary.bulletHit(Rules.getBulletDamage((double)event.getBullet().getPower()));
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ShotAtEnemy myShot = this.liveShotsAtEnemy.get(event.getBullet());
        if (myShot != null) {
            EnemyRobot intendedTarget = myShot.getEnemy();
            if (intendedTarget.isAlive()) {
                myShot.setStatus(ShotAtEnemy.ShotStatus.MISS);
            } else {
                myShot.setStatus(ShotAtEnemy.ShotStatus.ALREADY_DEAD);
            }
            this.liveShotsAtEnemy.remove(event.getBullet());
        } else {
            this.panic("OOOOPS - No such shot!!!!");
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        ShotAtEnemy myShot = this.liveShotsAtEnemy.get(event.getBullet());
        if (myShot != null) {
            myShot.setStatus(ShotAtEnemy.ShotStatus.HIT_BULLET);
            this.liveShotsAtEnemy.remove(event.getBullet());
            EnemyRobot enemy = enemies.getEnemy(event.getHitBullet().getName());
            Location bulletLocation = new Location(event.getHitBullet().getX(), event.getHitBullet().getY());
            DangerousBullet whatHitUs = null;
            double hittingDistance = 0.0;
            double marginForError = 30.0;
            for (DangerousBullet bullet : this.getDangerousBullets()) {
                if (!bullet.isPossibleLocation(bulletLocation, this.getTime(), event.getHitBullet().getPower(), marginForError, enemy)) continue;
                double distanceFromUs = Geometry.getDistanceBetweenLocations(bullet.getLocationAtTime(this.getTime()), this.myLocation);
                if (whatHitUs != null && !(distanceFromUs < hittingDistance)) continue;
                whatHitUs = bullet;
                hittingDistance = distanceFromUs;
            }
            if (whatHitUs != null) {
                this.dangerousBullets.remove(whatHitUs);
            }
        } else {
            this.panic("OOOOPS - No such shot!!!!");
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        if (this.usedFilesInThisRound) {
            System.out.println("Skipped turn due to file read/write - nothing to worry about");
        } else {
            this.panic("Skipped Turn");
        }
    }

    private void panic(String errorMessage) {
        System.out.println("*** PANIC ***");
        System.out.println(errorMessage);
        System.out.println("*************");
        this.setPanicColours();
    }

    public void setPanicColours() {
        this.setAllColors(Color.RED);
    }

    public void onDeath(DeathEvent event) {
        this.cleanupEndOfRound();
        this.roundSummary.setPlacing(this.getOthers() + 1);
        this.roundSummary.setEndTime(this.getTime());
        this.roundSummary.setFinalEnergy(this.getEnergy());
    }

    public void onWin(WinEvent event) {
        super.onWin(event);
        this.roundSummary.setPlacing(1);
        this.roundSummary.setEndTime(this.getTime());
        this.roundSummary.setFinalEnergy(this.getEnergy());
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.cleanupEndOfRound();
    }

    public void onBattleEnded(BattleEndedEvent event) {
        if (displayFinalDebugStats) {
            this.displayDebugInfoEndOfBattle();
        }
        for (EnemyRobot enemy : enemies) {
            this.recordEnemyStatsInDataFile(enemy);
        }
    }

    private void cleanupEndOfRound() {
        for (ShotAtEnemy shot : this.liveShotsAtEnemy.values()) {
            shot.setStatus(ShotAtEnemy.ShotStatus.END_ROUND);
        }
    }

    private void purgeDangerousBulletsGoneOutOfBattle() {
        ListIterator<DangerousBullet> iter = this.dangerousBullets.listIterator();
        while (iter.hasNext()) {
            DangerousBullet bullet = iter.next();
            if (bullet.getLocationAtTime(this.getTime()).isOnBattlefield(this.getBattleFieldWidth(), this.getBattleFieldHeight())) continue;
            iter.remove();
        }
    }

    private void purgeDangerousBulletsMovingAwayFromUs() {
        ListIterator<DangerousBullet> iter = this.dangerousBullets.listIterator();
        while (iter.hasNext()) {
            double previousDistance;
            DangerousBullet bullet = iter.next();
            double currentDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), bullet.getLocationAtTime(this.getTime()));
            if (!(currentDistance >= (previousDistance = Geometry.getDistanceBetweenLocations(this.getLocation(), bullet.getLocationAtTime(this.getTime() - 1L))) + 8.0)) continue;
            iter.remove();
        }
    }

    private void processPerfectSimulatedBullets() {
        for (PerfectSimulatedBullet perfectBullet : this.perfectSimulatedBullets) {
            perfectBullet.processAtTime(this.getTime());
        }
    }

    public abstract void setupEnemyStrategies(EnemyRobot var1);

    public final void run() {
        this.setColours();
        this.setBattleConstants();
        enemies.resetForNextRound();
        this.liveShotsAtEnemy = new HashMap();
        this.dangerousBullets = new ArrayList<DangerousBullet>();
        this.perfectSimulatedBullets = new ArrayList<PerfectSimulatedBullet>();
        this.myLocation = new Location(this.getX(), this.getY());
        this.averageLocation = new AverageLocation(myAverageLocationWeightingFactor);
        this.roundSummary = new RoundSummary();
        roundSummaries.add(this.roundSummary);
        this.roundSummary.setStartingLocation(this.myLocation);
        this.informAboutThisNewRobotInstance();
        this.initialiseRobotCommands();
        double previousGunHeat = this.getGunHeat();
        while (true) {
            this.purgeDangerousBulletsGoneOutOfBattle();
            this.purgeDangerousBulletsMovingAwayFromUs();
            this.processPerfectSimulatedBullets();
            this.myLocation = new Location(this.getX(), this.getY());
            this.averageLocation.recordLocation(this.myLocation);
            boolean bl = this.justFired = previousGunHeat < this.getGunHeat();
            this.gunNotFiredPeriod = previousGunHeat == 0.0 && this.getGunHeat() == 0.0 ? ++this.gunNotFiredPeriod : 0;
            previousGunHeat = this.getGunHeat();
            this.adjustRobotCommands();
            this.hitByBullet = false;
            this.rammedEnemy = false;
            if (this.navigatorCommand != null) {
                this.setTurnRight(this.navigatorCommand.getRightTurn());
                this.setAhead(this.navigatorCommand.getAhead());
                this.setMaxVelocity(this.navigatorCommand.getVelocity());
            }
            if (this.radarCommand != null) {
                this.setAdjustRadarForGunTurn(true);
                this.setAdjustRadarForRobotTurn(true);
                this.setTurnRadarRight(this.radarCommand.getRightTurn());
            }
            if (this.gunnerCommand != null) {
                this.setAdjustGunForRobotTurn(true);
                if (this.getGunHeat() == 0.0 && this.gunnerCommand.getFire() > 0.0) {
                    Bullet bullet = this.setFireBullet(this.gunnerCommand.getFire());
                    EnemyRobot enemy = this.gunnerCommand.getEnemyTarget();
                    if (bullet != null && enemy != null) {
                        ShotAtEnemy myShot = new ShotAtEnemy(this, enemy, bullet.getPower(), this.gunnerCommand.getAimingStrategy());
                        this.liveShotsAtEnemy.put(bullet, myShot);
                        String category = this.getShootingCategory(enemy, bullet.getVelocity());
                        enemy.recordMyShot(category, myShot);
                        this.perfectSimulatedBullets.add(new PerfectSimulatedBullet(enemy, this.getLocation(), this.getTime(), bullet.getVelocity()));
                        enemy.simulatePossibleShots(category, myShot);
                    }
                }
                this.setTurnGunRight(this.gunnerCommand.getRightTurn());
            }
            this.execute();
            this.displayDebugInfoPerTurn();
            if (this.getTime() == 100L) {
                this.roundSummary.setEnergyAtTime100(this.getEnergy());
            } else if (this.getTime() == 200L) {
                this.roundSummary.setEnergyAtTime200(this.getEnergy());
            }
            if (this.navigatorCommand != null) {
                this.navigatorCommand.executed();
            }
            if (this.radarCommand != null) {
                this.radarCommand.executed();
            }
            if (this.gunnerCommand == null) continue;
            this.gunnerCommand.executed();
        }
    }

    protected void adjustRobotCommands() {
    }

    protected void initialiseRobotCommands() {
    }

    protected void displayDebugInfoPerTurn() {
    }

    protected void displayDebugInfoPerRound() {
    }

    protected void displayDebugInfoEndOfBattle() {
        System.out.println(RoundSummary.getResultHeadingWithTabs());
        for (RoundSummary summary : roundSummaries) {
            System.out.println(summary.getResultWithTabs());
        }
    }

    public String getShootingCategory(EnemyRobot enemy, double bulletSpeed) {
        return "DEFAULT";
    }

    protected void setColours() {
        this.setBodyColor(Color.red);
        this.setGunColor(Color.black);
        this.setRadarColor(Color.yellow);
        this.setBulletColor(Color.green);
        this.setScanColor(Color.green);
    }

    private void setBattleConstants() {
        BattleConstants.getInstance().setBattlefieldHeight(this.getBattleFieldHeight());
        BattleConstants.getInstance().setBattlefieldWidth(this.getBattleFieldWidth());
        BattleConstants.getInstance().setRobotHeight(this.getHeight());
        BattleConstants.getInstance().setRobotWidth(this.getWidth());
        BattleConstants.getInstance().setGunCoolingRate(this.getGunCoolingRate());
    }

    private void informAboutThisNewRobotInstance() {
        for (AimingStrategy aimingStrategy : enemies.getAllAimingStrategies()) {
            aimingStrategy.processEndOfRound(this);
        }
        for (EnemyShootingAtUsStrategy strategy : enemies.getAllShootingAtUsStrategies()) {
            strategy.processEndOfRound(this);
        }
        this.displayDebugInfoPerRound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordEnemyStatsInDataFile(EnemyRobot enemy) {
        this.usedFilesInThisRound = true;
        PrintStream w = null;
        try {
            w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(enemy.getDataFileName())));
            enemy.recordStatsInDataFile(w);
            if (w.checkError()) {
                System.out.println("WARNING - unknown error when writing data file for enemy : " + enemy.getName());
            }
        }
        catch (IOException e) {
            System.out.println("IOException trying to write data file for enemy : " + enemy.getName());
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEnemyStatsFromDataFile(EnemyRobot enemy) {
        this.usedFilesInThisRound = true;
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.getDataFile(enemy.getDataFileName())));
                String dataLine = reader.readLine();
                while (dataLine != null) {
                    enemy.processLineFromDataFile(dataLine);
                    dataLine = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error trying to read data file for enemy : " + enemy.getName());
            e.printStackTrace();
        }
    }
}

