/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.core.Snapshot;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.physics.StaticLineWithMidpointImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.tactics.grail.BearingOffsetRange;
import pedersen.tactics.grail.TargetingSuccess;
import pedersen.tactics.targeting.TargetingMethod;

public class WaveData
implements Debuggable {
    public final double originalAcceleration;
    public final int originalTimeToImpactWall;
    public final int originalTimeToTarget;
    public final double originalLateralVelocity;
    public final double originalDistanceFromCenter;
    public final double originalBearingToTarget;
    public final long originalElapsedTimeSinceLastStop;
    private final List bearingOffsetRanges = new ArrayList();
    private final List targetingSucess = new ArrayList();
    public boolean isLinearProjectionDataAvailable = false;
    public StaticPosition originalFiringPosition = null;
    public StaticLineWithMidpointImpl originalTargetPositionWithDirectionOfTravel = null;
    public double originalTargetVelocity;
    private boolean isLiveRound = false;

    public WaveData(long h, double g, double f, int e, int d, double c, double bearingToTarget) {
        this.originalElapsedTimeSinceLastStop = h;
        this.originalDistanceFromCenter = g;
        this.originalAcceleration = f;
        this.originalTimeToImpactWall = e;
        this.originalTimeToTarget = d;
        this.originalLateralVelocity = c;
        this.originalBearingToTarget = bearingToTarget;
    }

    public void addBearingOffsetRange(BearingOffsetRange bearingOffsetRange) {
        this.bearingOffsetRanges.add(bearingOffsetRange);
    }

    public void addTargetingSuccess(TargetingMethod targetingMethod, boolean success) {
        this.targetingSucess.add(new TargetingSuccess(targetingMethod, success));
    }

    public Iterator getBearingOffsetRangeIterator() {
        return this.bearingOffsetRanges.iterator();
    }

    public Iterator getTargetingSuccessIterator() {
        return this.targetingSucess.iterator();
    }

    public void setLinearProjectionData(StaticPosition firingPosition, Snapshot target) {
        this.isLinearProjectionDataAvailable = true;
        this.originalFiringPosition = new StaticPositionImpl(firingPosition);
        this.originalTargetPositionWithDirectionOfTravel = new StaticLineWithMidpointImpl(target);
        this.originalTargetVelocity = target.getVelocity();
    }

    public void setLiveRound() {
        this.isLiveRound = true;
    }

    public boolean isLiveRound() {
        return this.isLiveRound;
    }

    public void debug() {
        Debug.debug("no debug information defined");
    }
}

