/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentBase;
import pedersen.tactics.grail.SegmentStatisticsImpl;
import pedersen.tactics.targeting.TargetingMethod;

public class SegmentLateralVelocityImpl
extends SegmentBase
implements Segment {
    public static final double maximumValue = 8.0;
    private static final int maxBinSize = 8;

    public SegmentLateralVelocityImpl() {
        super(8.0, 8);
        this.zero = new SegmentStatisticsImpl();
        this.positive = new SegmentStatisticsImpl[0];
        this.negative = new SegmentStatisticsImpl[0];
        this.buildOrganicBins();
    }

    protected void buildOrganicBins() {
        if (this.positiveBinSize != this.positive.length) {
            this.positive = new SegmentStatisticsImpl[this.positiveBinSize];
            int i = 0;
            while (i < this.positiveBinSize) {
                this.positive[i] = new SegmentStatisticsImpl();
                ++i;
            }
            Iterator iterator = this.positiveWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
        if (this.negativeBinSize != this.negative.length) {
            this.negative = new SegmentStatisticsImpl[this.negativeBinSize];
            int i = 0;
            while (i < this.negativeBinSize) {
                this.negative[i] = new SegmentStatisticsImpl();
                ++i;
            }
            Iterator iterator = this.negativeWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
    }

    public void addWaveData(WaveData waveData) {
        super.addWaveData(waveData, waveData.originalLateralVelocity);
    }

    public void addWaveDataBypass(WaveData waveData) {
        super.addWaveDataBypass(waveData, waveData.originalLateralVelocity);
    }

    public double getMostVisitedBearingOffset(WaveData waveData) {
        return super.getMostVisitedBearingOffset(waveData, waveData.originalLateralVelocity);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData) {
        return super.getLeastVisitedBearingOffset(waveData, waveData.originalLateralVelocity);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return super.getMostVisitedLinearProjection(waveData, waveData.originalLateralVelocity);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        return super.getFavoredTargetingMethod(waveData, waveData.originalLateralVelocity);
    }

    public static double calculateOrbitalVelocity(double bearing, double heading, double velocity) {
        return velocity * Math.cos(heading - (bearing + 1.5707963267948966));
    }
}

