/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import java.util.Iterator;
import pedersen.core.Snapshot;
import pedersen.misc.Arena;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public class MovementMethodMinimumRiskImpl
extends MovementMethodBase {
    public MovementMethodMinimumRiskImpl() {
        super(19);
    }

    public StaticPosition getRelativePositionTarget(Snapshot combatant, Snapshot t_arget, long t_ime) {
        double distance;
        DynamicPositionImpl vectorSum = new DynamicPositionImpl();
        StaticPosition minimumRiskPoint = null;
        double minimumRiskDistanceRating = 0.0;
        StaticPosition[] point = this.getPoints(9, 9);
        int i = 0;
        while (i < point.length) {
            double distanceRating = this.getDistanceRating(point[i]);
            if (distanceRating > minimumRiskDistanceRating) {
                minimumRiskPoint = point[i];
                minimumRiskDistanceRating = distanceRating;
            }
            ++i;
        }
        if (minimumRiskPoint != null && (distance = combatant.getDistance(minimumRiskPoint)) > 200.0) {
            vectorSum.add(new StaticVectorImpl(combatant.getBearing(minimumRiskPoint), Math.sqrt(distance)));
        }
        return vectorSum.getStaticPosition();
    }

    private StaticPosition[] getPoints(int columns, int rows) {
        StaticPosition[] point = new StaticPosition[rows * columns];
        double xMargin = Arena.getMaxX() / (double)(2 * columns + 1);
        double yMargin = Arena.getMaxY() / (double)(2 * rows + 1);
        int i = 0;
        while (i < columns) {
            int j = 0;
            while (j < rows) {
                point[i * rows + j] = new StaticPositionImpl(xMargin + 2.0 * xMargin * (double)i, yMargin + 2.0 * yMargin * (double)j);
                ++j;
            }
            ++i;
        }
        return point;
    }

    private double getDistanceRating(StaticPosition position) {
        double distanceRating = 0.0;
        Iterator iterator = TargetBank.singleton.iterator();
        while (iterator.hasNext()) {
            Target target = (Target)iterator.next();
            if (!target.isActive()) continue;
            distanceRating += Math.pow(position.getDistance(target), 2.0);
        }
        return distanceRating;
    }
}

