/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Heading;
import shrub.Location;

public class Sighting {
    private final Location mLocation;
    private final Heading mHeading;
    private final double mVelocity;
    private final double mEnergy;
    private final int mInaccuracy;
    private final long mTimestamp;
    private final String mName;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public static Sighting valueOf(String name, double velocity, Location locn, Heading heading, double energy, int inaccuracy, long timestamp) {
        Sighting newObj = new Sighting(name, velocity, locn, heading, energy, inaccuracy, timestamp);
        return newObj;
    }

    private Sighting(String name, double velocity, Location locn, Heading heading, double energy, int inaccuracy, long timestamp) {
        this.mName = name;
        this.mLocation = locn;
        this.mHeading = heading;
        this.mVelocity = velocity;
        this.mEnergy = energy;
        this.mInaccuracy = inaccuracy;
        this.mTimestamp = timestamp;
    }

    public final Location GetLocation() {
        return this.mLocation;
    }

    public final Heading GetHeading() {
        return this.mHeading;
    }

    public final double GetVelocity() {
        return this.mVelocity;
    }

    public final double GetEnergy() {
        return this.mEnergy;
    }

    public final int GetInaccuracy() {
        return this.mInaccuracy;
    }

    public final long GetTimestamp() {
        return this.mTimestamp;
    }

    public final String GetName() {
        return this.mName;
    }

    public void Print() {
        System.out.print(" Time: " + this.mTimestamp);
        System.out.print(" Locn: " + this.mLocation.toString());
        System.out.print(" Hdng: " + this.mHeading.toString());
        System.out.println();
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

