/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.structures;

public class FloatingHeap<T> {
    private static int INITIAL_CAP = 3;
    private static double FACTOR = 1.7;
    protected int capacity;
    protected int size;
    protected double[] key;
    protected Object[] data;
    protected int signal;

    public FloatingHeap(int n) {
        this.signal = n;
        this.size = 0;
        this.capacity = INITIAL_CAP;
        this.data = new Object[this.capacity];
        this.key = new double[this.capacity];
    }

    void rellocate(int n) {
        double[] dArray = new double[n];
        Object[] objectArray = new Object[n];
        System.arraycopy(this.key, 0, dArray, 0, this.size);
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        this.key = dArray;
        this.data = objectArray;
        this.capacity = n;
    }

    void resize(int n) {
        if (n <= this.size) {
            return;
        }
        this.rellocate(n);
    }

    void ensure(int n) {
        if (n > this.capacity) {
            this.resize(Math.max(n, (int)Math.ceil(FACTOR * (double)n)));
        }
    }

    void ensure() {
        this.ensure(this.size + 1);
    }

    public int size() {
        return this.size;
    }

    public void push(double d, T t) {
        this.ensure();
        this.key[this.size] = d;
        this.data[this.size] = t;
        this.heapifyUp(this.size++);
    }

    protected double weighted(int n) {
        return this.key[n] * (double)this.signal;
    }

    private void heapifyUp(int n) {
        while (n > 0 && this.weighted((n - 1) / 2) < this.weighted(n)) {
            double d = this.key[n];
            this.key[n] = this.key[(n - 1) / 2];
            this.key[(n - 1) / 2] = d;
            Object object = this.data[n];
            this.data[n] = this.data[(n - 1) / 2];
            this.data[(n - 1) / 2] = object;
            n = (n - 1) / 2;
        }
    }

    public Entry<T> top() {
        return new Entry(this.key[0], this.data[0]);
    }

    public void pop() {
        if (this.size == 0) {
            throw new RuntimeException();
        }
        --this.size;
        this.key[0] = this.key[this.size];
        this.data[0] = this.data[this.size];
        this.data[this.size] = null;
        if (this.size > 0) {
            this.heapifyDown(0);
        }
    }

    private void heapifyDown(int n) {
        if (2 * n + 1 >= this.size) {
            return;
        }
        int n2 = 2 * n + 1;
        double d = this.weighted(n2);
        if (2 * n + 2 < this.size && d < this.weighted(2 * n + 2)) {
            n2 = 2 * n + 2;
            d = this.weighted(2 * n + 2);
        }
        if (d > this.weighted(n)) {
            double d2 = this.key[n];
            this.key[n] = this.key[n2];
            this.key[n2] = d2;
            Object object = this.data[n];
            this.data[n] = this.data[n2];
            this.data[n2] = object;
        }
        this.heapifyDown(n2);
    }

    public static class Min<T>
    extends FloatingHeap<T> {
        public Min() {
            super(-1);
        }
    }

    public static class Max<T>
    extends FloatingHeap<T> {
        public Max() {
            super(1);
        }
    }

    public static class Entry<T> {
        public final double key;
        public final T payload;

        private Entry(double d, T t) {
            this.key = d;
            this.payload = t;
        }
    }
}

