package kvk.Utils;

/**
 *  Wave pour stocker les informations sur les ennemis
 *  Code issu de cx.mini.Nimrod v0.55
 *
 * @author     Ssin.le.Terrible
 * @created    12 janvier 2004
 */
public class Wave {
	//{{{*** Variables
	private  double  linePreDiffAngle;
	private  double  enemyBearingToCenter;
	private  double  distance;
	private  Point   startPoint;
	private  long    startTime;
	private  double  absBearing;
	//}}}

	public Wave(Point p, long time, double bearing, double dist, double lPDA, double eBTC) {
		startPoint = p;
		startTime = time;
		absBearing = bearing;
		distance = dist / 90d;
		linePreDiffAngle = lPDA;
		enemyBearingToCenter = eBTC;
	}

	//**********************************************************//
	public Point getStartPoint() {
	return startPoint;
}
	//**********************************************************//

	public double getComVal(Wave wave, double dir) {
		return Math.abs(linePreDiffAngle - wave.linePreDiffAngle * dir) + Math.abs(distance - wave.distance) + Math.abs(enemyBearingToCenter - wave.enemyBearingToCenter);
	}

	public void test(Point p, long time) {
		if (startPoint.getX() > 11) {                                                 //la wave n'a pas encore touche, il faut la teste
			double  travel;
			if ((travel = 11 * (time - startTime)) < 0) {                                //la wave n'a plus de sens au tour suivant
				startPoint.setX(10d);                                                       //10d signifie qu'elle est inutile
				return;
			}
			if (Math.abs(p.distance(startPoint) - travel) < BattleField.getRobotSize()) {//la wave a touche l'ennemi
				startPoint = new Point(Fct.bearing( startPoint,p) - absBearing, p.distance(startPoint));
			}
		}
	}
}

