package arthord;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.Random;

/**
 * NanoSatanMelee - a robot by Kuuran
 * 
 * Alpha: A first foray into melee bots. Uses a goto engine to achieve a random smooth nearest-corner movement.
 * Beta: Fixed nasty bug in turn assurance, fixed not using the full corner on one axis, cleaned up and shrunk code somewhat.
 *       Also tweaked parameters. Unfortunately it still tends to fail to win crowded corners due to bad target locking.
 * 
 */
public class NanoSatanMelee extends AdvancedRobot
{
	static final int MANEUVER_SPACE = 300; // Space to maneuver in
	static final int ENERGY_CONSERVATION_CONSTANT = 5; // From exactly this energy level to disabled only 0.1 power will be fired
	static final int WALL_BUFFER = 25; // Distance to remain from walls
	static final int RECIPROCAL_SCALE_FACTOR = (WALL_BUFFER + MANEUVER_SPACE) * WALL_BUFFER; // Factor to ensure even corner movement
	static final double TURN_PAUSE_THRESHOLD = Math.PI/6; // Turn angle in radians at which to stop for adjustment

	/**
	 * run: NanoSatanMelee's default behavior
	 */
	public void run()
	{
		double dX = 0, dY = 0;
		setTurnGunRight(Double.POSITIVE_INFINITY);

		while(true)
		{
			if(getDistanceRemaining() == 0)
			{
				dY = Math.random() * MANEUVER_SPACE + WALL_BUFFER;
				dX = RECIPROCAL_SCALE_FACTOR / dY + WALL_BUFFER;

				if(getX() > getBattleFieldWidth() / 2)
					dX = getBattleFieldWidth() - dX;
				if(getY() > getBattleFieldHeight() / 2)
					dY = getBattleFieldHeight() - dY;
			}

			double turnRemaining = Math.atan2(dX - getX(), dY - getY()) - getHeadingRadians();
			double distanceRemaining = Point2D.Double.distance(getX(), getY(), dX, dY);

			if(turnRemaining > Math.PI/2)
			{
				turnRemaining -= Math.PI;
				distanceRemaining = -distanceRemaining;
			}
			if(turnRemaining < -Math.PI/2)
			{
				turnRemaining += Math.PI;
				distanceRemaining = -distanceRemaining;
			}

			setMaxVelocity(0);
			if(Math.abs(turnRemaining) < TURN_PAUSE_THRESHOLD)
				setMaxVelocity(8);

			setTurnRightRadians(turnRemaining);
			setAhead(distanceRemaining);

			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		setFire(3);

		// An attempt towards target-locking
		if(e.getDistance() * getOthers() < 2000)
			setTurnGunLeft(getGunTurnRemaining());
	}
}