package germ;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;

/**
 * TheMind - by Germ
 * TheMind is a crazy thing 
 *
 * Sections of the movement class were taken from Snipet bot
 * Linear Targeting from the RoboWiki
 */
public class TheMind extends AdvancedRobot
{
					//direction we are heading...1 = forward, -1 = backwards
	final double PI = Math.PI;			//just a constant
	double way = 1;
	static double direction=1;
	double firePower = 1;
	double NRG = 0.0;
	double myX = 0;
	double myY = 0;
	public double bearing;
	public double distance;
		
	public void run() {
		setColors(Color.lightGray,Color.pink,Color.red);	
		setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
		
		while(true) {
		setTurnRadarRight(Double.POSITIVE_INFINITY);
		scan();
		}
	}
	void doFirePower() {
		if (NRG < 1.5 || getEnergy() > 10)
			firePower = NRG;
		else if (getEnergy()<10)
			firePower = .2;
		else
			firePower = 400/distance;//selects a bullet power based on our distance away from the target

   }
	void move(){
		double rand = Math.random()*.5;
		double random = 50+(Math.random()*100);
       //if wall is too close then change direction
		if(myX<50 || myY<50 || myX>getBattleFieldWidth()-50 || myY>getBattleFieldHeight()-50){
			setTurnRightRadians(180);
			setAhead(random);
			}
		else{
			if (getEnergy() < 50)
				way = 2;
			//from Snippetbot
			if (getTime()%20 == 0)  { 		//every twenty 'ticks'
         	   direction *= -1;		//reverse direction
          	  setAhead(direction*300);	//move in that direction
			}	
			//from Snippetbot, altered
			setTurnRightRadians((bearing)+ (PI/way+rand)); //every turn move to circle strafe the enemy or move in odd square
		}
	
    }
	public void onScannedRobot(ScannedRobotEvent e) {
		NRG = e.getEnergy();
			move();
		doFirePower();
		  
		myX = getX();
		 myY = getY();
		//if(getEnergy()<50)
			//bearing = e.getBearingRadians();
		distance = e.getDistance();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = myX + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = myY + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX+Math.sin(enemyHeading) * enemyVelocity;
		double predictedY = enemyY+Math.cos(enemyHeading) * enemyVelocity;;
		double theta = Utils.normalAbsoluteAngle(Math.atan2(predictedX - getX(), predictedY - getY()));
		
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		setTurnGunRightRadians(Utils.normalRelativeAngle(theta - getGunHeadingRadians()));
		if (NRG !=0.0 && getEnergy() > 5)
			fire(firePower);
		else if(NRG == 0.0){
			turnRight(e.getBearing());
			setAhead(e.getDistance() + 5);
		}
		}
}
