package SHAM;

import robocode.*;


/**
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar Period 3, JAVA
 * Programming Due: 06/05/09 Robocode, JAVA, Second Semester Final Project
 * 
 * Used in our melee mode. Essentially what the walls sample robot does. Follows
 * the walls closely. Takes care of hitting another robot.
 */

public class WallMover
{
    private AdvancedRobot _robot;


    public WallMover( AdvancedRobot robot )
    {
        _robot = robot;
    }


    public void onScannedRobot( ScannedRobotEvent e )
    {
        // goes to find a wall once put onto field
        if ( _robot.getHeading() % 90 != 0 )
        {
            _robot.setTurnLeft( _robot.getHeading() % 90 );
        }

        // moves ahead to wall
        _robot.setAhead( Double.POSITIVE_INFINITY );

        // if you're velocity = 0, essentially you have stopped
        // then turn right and you'll still follow the next wall
        if ( _robot.getVelocity() == 0 )
        {
            _robot.setTurnRight( 90 );
        }
    }


    public void onHitRobot( HitRobotEvent e )
    {
        // // If he's in front of us, set back up a bit.
        if ( e.getBearing() > -90 && e.getBearing() < 90 )
        {
            _robot.back( 100 );
            // get off the wall a bit then continue in same direction
            _robot.setTurnRight( 90 );
            _robot.setAhead( 72 );
            _robot.setTurnLeft( 90 );
            _robot.setAhead( Double.POSITIVE_INFINITY );
        }
        // else he's in back of us, so set ahead a bit.
        else
            _robot.ahead( 100 );
    }

}