package ags.surreptitious.info;

import ags.util.points.*;
import robocode.*;

public class EnemyInfo {
    private AbsolutePoint location;
    private RelativePoint velocity;
    private double energy;
    private final String name;
    public boolean isNew;
    public EnemyInfo(String name) {
        this.name = name;
    }
    
    public void handleEvent(StatusInfo status, ScannedRobotEvent e) {
        location = status.location.addRelativePoint(RelativePoint.fromDM(e.getBearingRadians()+status.velocity.direction, e.getDistance()));
        velocity = RelativePoint.fromDM(e.getHeadingRadians(), e.getVelocity());
        energy = e.getEnergy();
    }
    
    public AbsolutePoint getLocation() {
        return location;
    }
    public RelativePoint getVelocity() {
        return velocity;
    }
    public double getEnergy() {
        return energy;
    }
    public String getNAme() {
        return name;
    }
}
