package kawigi.spare.parts;
import robocode.*;
/**
 * CornerMovement - a movement pattern that oscillates in the corner
 */
public class CornerMovement extends MovementStrategy implements java.io.Serializable
{
	private double cornerdistance, walldistance;
	private transient double targetX, targetY, corner;
	private transient boolean back;
	private transient int quickhits;
	private transient long lastHitTime;
	
	public CornerMovement(AdvancedRobot robot, TargetSelector targetter)
	{
		super(robot, targetter);
		cornerdistance = 200;
		walldistance = robot.getWidth();
		pickCorner();
	}
	
	public void pickCorner()
	{
		corner = Math.random();
		if (corner < .5)
			targetX = walldistance;
		else
			targetX = robot.getBattleFieldWidth()-walldistance;
		if (corner < .25 || corner > .75)
			targetY = cornerdistance;
		else
			targetY = robot.getBattleFieldHeight()-cornerdistance;
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof HitRobotEvent)
		{
			if (((HitRobotEvent)e).isMyFault())
				pickCorner();
		}
		else if (e instanceof HitByBulletEvent)
		{
			if (e.getTime() - lastHitTime < 35)
				pickCorner();
			else
				quickhits = 0;
			quickhits++;
			lastHitTime = e.getTime();
		}
	}
	
	public void setAction()
	{
		if (willHitWall() && (targetX-robot.getX())*(targetX-robot.getX())+(targetY-robot.getY())*(targetY-robot.getY()) < 400)	//distance < 20
		{
			if (corner < .5)
				if (targetX == walldistance)
					targetX = cornerdistance;
				else
					targetX = walldistance;
			else
				if (targetX == robot.getBattleFieldWidth()-walldistance)
					targetX = robot.getBattleFieldWidth()-cornerdistance;
				else
					targetX = robot.getBattleFieldWidth()-walldistance;
			if (corner < .25 || corner > .75)
				if (targetY == cornerdistance)
					targetY = walldistance;
				else
					targetY = cornerdistance;
			else
				if (targetY == robot.getBattleFieldHeight()-cornerdistance)
					targetY = robot.getBattleFieldHeight()-walldistance;
				else
					targetY = robot.getBattleFieldHeight()-cornerdistance;
		}
		//now move toward targetX, targetY
		double theta = Math.atan2(targetX-robot.getX(), targetY-robot.getY())-robot.getHeadingRadians();
		turn(theta);
		if (back)
			robot.setBack(100);
		else
			robot.setAhead(100);
		back = false;
	}
	
	public void turn(double angle)
	{
		while (angle < -Math.PI)
			angle += Math.PI*2;
		while (angle > Math.PI)
			angle -= Math.PI*2;
		if (angle < -Math.PI/2)
		{
			back = true;
			angle += Math.PI;
		}
		else if (angle > Math.PI/2)
		{
			back = true;
			angle -= Math.PI;
		}
		if (angle > 0)
			robot.setTurnRightRadians(angle);
		else
			robot.setTurnLeftRadians(-angle);
	}
	
	public boolean willHitWall()
	{
		double projX = Math.sin(robot.getHeadingRadians())*robot.getVelocity()*2;
		double projY = Math.cos(robot.getHeadingRadians())*robot.getVelocity()*2;
		if (back)
		{
			projX = robot.getX() - projX;
			projY = robot.getY() - projY;
		}
		else
		{
			projX += robot.getX();
			projY += robot.getY();
		}
		return (projX < walldistance || projY < robot.getWidth() || projX > robot.getBattleFieldWidth()-walldistance || projY > robot.getBattleFieldHeight()-walldistance);
	}
}
