package kawigi.spare.parts;
import java.util.Vector;
import kawigi.spare.util.*;
import robocode.*;
/**
 * IterativePatternMatcherGun - attempts to predict enemy movements iteratively using the last 8 or so movements (TBD)
 * 		My first attempt at MogBot-style pattern matching
 */
public class IterativePatternMatcherGun extends Gun implements java.io.Serializable
{
	//private Vector movements;
	private transient long lastUpdateTime;
	private transient Averager hitAverage;
	private transient double lastHeading;
	private transient EnemyState laststate;
	private transient double power;
	private transient EnemyManager enemies;
	
	public IterativePatternMatcherGun(AdvancedRobot robot, EnemyManager enemies)
	{
		super(robot);
		this.enemies = enemies;
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof ScannedRobotEvent)
		{
			ScannedRobotEvent ev = (ScannedRobotEvent)e;
			EnemyState newstate = new EnemyState(ev.getName());
			double ebearing = ev.getBearingRadians()+robot.getHeadingRadians();
			double ex = robot.getX()+ev.getDistance()*Math.sin(ebearing);
			double ey = robot.getY()+ev.getDistance()*Math.cos(ebearing);
			newstate.setState(ex, ey, ev.getVelocity(), ev.getHeading(), ev.getEnergy(), ev.getTime());
			EnemyState databaseState = enemies.getEnemy(ev.getName());
			if (laststate != null && databaseState == null)
			{
				long dt = laststate.getTimeElapsed(ev.getTime());
				EnemyStateChange change = laststate.getChange(newstate);
				for (int i=0; i<dt; i++)
					databaseState.addMovement(change);
				databaseState.trimMovements();
			}
			laststate = newstate;
		}
	}
	
	public ChooserBullet getVirtualBullet(EnemyState target)
	{
		if (target == null)
			return null;
		double choicerating = 100000;
		int bestindex = -1;
		Vector movements = target.getMovements();
		for(int i = 0; i < movements.size() - 20; i++)
		{
			double rating = 0;
			for(int j = 0; j < 10; j++)
			{
				EnemyStateChange matcher = (EnemyStateChange)movements.elementAt(movements.size()-10+j);
				EnemyStateChange t = (EnemyStateChange)movements.elementAt(j + i);
				rating += t.difference(matcher);
			}
			if(rating < choicerating)
			{
				choicerating = rating;
				bestindex = i + 10;
			}
		}
		//simulate movement and aim
		power = Math.min(3, 4-choicerating);
		power = Math.max(power, .1);
		power = Math.min(power, .2*robot.getEnergy());
		double bulletv = 20-3*power;
		double heading = target.getHeading();
		double bulletdistance = 0;
		EnemyState test = target.copy();
		int index = bestindex;
		double myx = robot.getX(), myy = robot.getY();
		while(bulletdistance < test.getDistance(myx, myy))
		{
			bulletdistance += bulletv;
			index++;
			if (index>=movements.size())
			{
				double time = bulletdistance/bulletv;
				double distance = test.getDistance(myx, myy);
				double neededv = distance/time;
				if (neededv > 19.7)
					power = .1;
				else
					power = (neededv-20)/3;
				break;
			}
			test.updateState((EnemyStateChange)movements.elementAt(index));
		}
		return new ChooserBullet(target.getName(), myx, myy, test.getAbsoluteBearing(myx, myy), power, this, robot.getTime());
	}
}
