package kawigi.spare.parts;
import kawigi.spare.SpareParts;
import kawigi.spare.util.*;
import robocode.*;
/**
 * MovementSelector - select movement patterns to use
 */
public class MovementSelector extends PartSelector
{
	private int[] meleeindeces, oneindeces, oscillatorindeces, directdodgeindeces;
	private int[] hits;
	private long[] timeused;
	private MovementStrategy[] movements;
	private int index;
	private long lastswitch;
	private AdvancedRobot robot;
	
	public MovementSelector(AdvancedRobot robot, TargetSelector targetter)
	{
		this.robot = robot;
		GravityManager mgr = new GravityManager(SpareParts.enemies);
		movements = new MovementStrategy[9];
		movements[0] = new AntiGravityMovement(robot, targetter, mgr);	//currently doesn't work, so its index is never used.
		movements[1] = new SpiralMovement(robot, targetter);
		movements[2] = new WallMovement(robot, targetter);
		movements[3] = new OscillatingMovement(robot, targetter);
		movements[4] = new CornerMovement(robot, targetter);
		movements[5] = new RandomMovement(robot, targetter);
		movements[6] = new MagnetMovement(robot, targetter);
		movements[7] = new SillyOscillatingMovement(robot, targetter);
		movements[8] = new BulletDodgerMovement(robot, targetter, mgr);
		meleeindeces = new int[]{1, 2, 3, 4, 7, 8};
		oneindeces = new int[]{1, 2, 3, 5, 6, 7, 8};
		oscillatorindeces = new int[]{3, 4, 5, 7, 8};	//this could eventually be used if the enemy were found to only be using linear/circular aiming
		directdodgeindeces = new int[]{1, 2, 8};	//this could eventually be used if the enemy were found to only shoot directly at me
		hits = new int[movements.length];
		timeused = new long[hits.length];
		for (int i=0; i<timeused.length; i++)
			timeused[i] = 1;
			
	}
	
	public void onEvent(Event e)
	{
		if (e instanceof HitByBulletEvent)
		{
			hits[index]++;
		}
		for (int i=0; i<movements.length; i++)
			movements[i].onEvent(e);
	}
	
	public Part getSelectedPart()
	{
		if (lastswitch < robot.getTime())
			timeused[index] += robot.getTime()-lastswitch;
		lastswitch = robot.getTime();
		int bestindex = 0;
		int[] indeces;
		EnemyState target = SpareParts.getSelectedTarget();
		if (robot.getOthers() == 1)
			indeces = oneindeces;
		else
			indeces = meleeindeces;
		for (int i=0; i<indeces.length; i++)
			if ((double)hits[indeces[i]]/timeused[indeces[i]] < (double)hits[bestindex]/timeused[bestindex] && timeused[bestindex] > 200)
				bestindex = indeces[i];
		index = bestindex;
		if (target != null && target.getEnergy() == 0 && robot.getOthers() == 1)
			index = 5;
		return movements[index];
	}
}
