package kawigi.spare.util;
import kawigi.spare.parts.*;
import kawigi.spare.SpareParts;
import java.awt.geom.*;
import robocode.*;
/**
 * DefensiveVirtualBullet - an offensive virtual bullet to help pick the best virtual gun.
 */
public class DefensiveVirtualBullet
{
	private double startx, starty, heading, bulletv, power, projX, projY;
	private long firetime;
	
	public DefensiveVirtualBullet(double x, double y, double direction, double power, long currentTime, double projectedX, double projectedY)
	{
		startx = x;
		starty = y;
		heading = direction;
		bulletv = 20-power/3;
		this.power = power;
		firetime = currentTime;
		projX = projectedX;
		projY = projectedY;
	}
	
	public double getX(long currentTime)
	{
		double distance = bulletv*(currentTime-firetime);
		return Math.sin(heading)*distance+startx;
	}
	
	public double getY(long currentTime)
	{
		double distance = bulletv*(currentTime-firetime);
		return Math.cos(heading)*distance+starty;
	}
	
	public boolean isInactive(long time)
	{
		double x = getX(time);
		double y = getY(time);
		return (x < 0 || y < 0 || x > SpareParts.fieldx || y > SpareParts.fieldy);
	}
	
	public boolean intersectsVirtualLaser(double projx, double projy, long time)
	{
		Line2D boundingLine = getVirtualLaser(time);
		java.awt.geom.Rectangle2D.Float boundingBox = new java.awt.geom.Rectangle2D.Float();
		boundingBox.setRect(projx - 18, projy - 18, 36, 36);
		return (boundingBox.intersectsLine(boundingLine));
	}
	
	public Line2D getVirtualLaser(long time)
	{
		Line2D boundingLine = new java.awt.geom.Line2D.Double();
		double backX = 10*(time-firetime-2)*Math.sin(heading)+startx;	//coordinates of slowest bullet 2 turns ago
		double backY = 10*(time-firetime-2)*Math.cos(heading)+starty;
		double frontX = 20*(time-firetime+15)*Math.sin(heading)+startx;	//find coordinates of fastest bullet in 10 turns
		double frontY = 20*(time-firetime+15)*Math.cos(heading)+starty;
		boundingLine.setLine(backX, backY, frontX, frontY);
		return boundingLine;
	}
	
	public double getPower()
	{
		return power;
	}
	
	public GravityVector getGravity(long time)
	{
		//adding 2 to think ahead (and figure that I might have found out about the bullet late, too)
		return new GravityVector(projX, projY, 500+power*100, 2);
	}
	
	//in reality, this "EnemyState" is myself.
	public static DefensiveVirtualBullet[] createBullets(double x, double y, double power, EnemyState me, long time)
	{
		DefensiveVirtualBullet direct = new DefensiveVirtualBullet(x, y, me.getAbsoluteBearing(x, y), power, time, me.getX(), me.getY());
		DefensiveVirtualBullet linear = getPredictingBullet(x, y, power, me, time, true, true);
		DefensiveVirtualBullet linearAv = getPredictingBullet(x, y, power, me, time, false, true);
		DefensiveVirtualBullet circular = getPredictingBullet(x, y, power, me, time, true, false);
		DefensiveVirtualBullet circularAv = getPredictingBullet(x, y, power, me, time, false, false);
		return new DefensiveVirtualBullet[]{direct, linear, linearAv, circular, circularAv};
	}
	
	private static DefensiveVirtualBullet getPredictingBullet(double x, double y, double power, EnemyState me, long time, boolean shortsighted, boolean linear)
	{
		double bulletv = 20-3*power;
		double wamba;
		if (!linear)
			if (!shortsighted)
				wamba = me.getRecentAverageAngularVelocity();
			else
				wamba = me.getLastHeadingChange();
		else
			wamba = 0;
		double vel;
		if (!shortsighted)
			vel = me.getRecentAverageVelocity();
		else
			vel = me.getVelocity();
		double heading = me.getHeading();
		double bulletdistance = 0;
		double ex = me.getX();
		double ey = me.getY();
		while(bulletdistance < Math.sqrt((ex-x)*(ex-x)+(ey-y)*(ey-y)))
		{
			bulletdistance += bulletv;
			heading += wamba;
			ex += vel*Math.sin(heading);
			ey += vel*Math.cos(heading);
			if (ex < 18 || ex > SpareParts.fieldx-18 || ey < 18 | ey > SpareParts.fieldy-18)
				break;
		}
		return new DefensiveVirtualBullet(x, y, Math.atan2(ex-x, ey-y), power, time, ex, ey);
	}
}
