package bvh.fry;

/**
 * Constanten zijn apart vastgelegd in een interface
 */
interface Constanten {
   static final double TWEEPI = 2D * Math.PI; // 360 graden draaien
   static final double PI = Math.PI; // 180 graden draaien
   static final double DRIEKWARTPI = 3D * Math.PI / 4D; // 135 graden draaien
   static final double HALFPI = Math.PI / 2D; //  90 graden draaien
   static final double DRIEACHTSTEPI = 3D * Math.PI / 8D; //  67.5 graden draaien
   static final double KWARTPI = Math.PI / 4D; //  45 graden draaien
   static final double EENACHTSTEPI = Math.PI / 8D; //  22.5 graden draaien
   static final double EENZESTIENDEPI = Math.PI / 16D; //  11.25 graden draaien
   static final double BOTGROOTTE = 36D; // de afmetingen van een robot
   static final double WANDAFSTAND = 44D; // minimale afstand tot wand: anders bewegingsrichting omkeren
   static final double RONDING = 80D; // ronding van slagveld
   static final double MAXIMUM_SNELHEID = 8D;
   static final double STANDAARDVUURKRACHT = 1.9D;
   static final double VUURKRACHTFACTOR = 0.06D; // stapjes waarmee vuurkracht wordt vergroot (was 0.4)
   static final double MAXIMUMVUURKRACHT = 3.0D;
   static final double MINIMUMVUURKRACHT = 0.5D;
   static final double RAAKAFSTAND = 18.0D;
   static final int    GF_MIDDEN = 15; // hoeksegmenten = 2*GF_MIDDEN+1
   static final int    SLAGKARAKTERISERING = 4;
   static final int    POSITIESEGMENTEN = 3;
   static final int    AFSTANDSEGMENTEN = 9;
   static final int    LATERALESNELHEIDSSEGMENTEN = 9;
   static final int    TRANSVERSALESNELHEIDSSEGMENTEN = 17;
   static final int    VERSNELLINGSSEGMENTEN = 3;
   static final double POSITIEAFSTOTINGSFACTOR = 10D;
   static final double HOEKAFSTOTINGSFACTOR = 100D;
   static final double CENTRUMAFSTOTINGSFACTOR = 10D;
   static final double AFSTANDWEEGFACTOR = 1D;
   static final double ENERGIEWEEGFACTOR = 1D;
   static final double SCOREWEEGFACTOR = 1D;
   static final double HOEKWEEGFACTOR = 1D;
   static final double KOGELHOEKWEEGFACTOR = 1D;
   static final double NABIJHEIDSFACTOR = 1D;
   static final double BOTSINGSFACTOR = 1D;
   static final double NABIJHEIDSAFSTAND = 300D;
   static final double KOGELAFSTANDWEEGFACTOR = 5000D;
} // EINDE CLASS Constanten
