package bvh.fry;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.Point2D;

class Golf extends Point2D.Double implements Constanten {
   public double         straal;
   public double         richting;
   public double         cirkelRichting;
   public double         kogelSnelheid;
   public long           laatsteTijd;
   public double[]       stats;
   public double[]       snelleStats;
   public Point2D.Double vorigePositieDoel;
   private double        maxOntsnappingsHoek = 0.6;
   private double        binBreedte = maxOntsnappingsHoek / (double)GF_MIDDEN;

   public Golf(Point2D.Double vuurpositie, Point2D.Double doel, double kogelSnelheid, double cirkelRichting, long tijd,
      double straal , double[] snelleStats, double[] trageStats) {
      this.setLocation(vuurpositie);
      this.richting = BotUtils.bepaalRichting(vuurpositie, doel);
      // de straal is variabel omdat deze afhankelijk is van het moment van detectie van de (inkomende) kogel).
      this.straal = straal; 
      this.kogelSnelheid = kogelSnelheid;
      this.cirkelRichting = cirkelRichting;
      this.maxOntsnappingsHoek = Math.asin(MAXIMUM_SNELHEID/kogelSnelheid);
      this.binBreedte = 1.1*this.maxOntsnappingsHoek / (double)GF_MIDDEN;
      this.laatsteTijd = tijd;
      this.stats = trageStats;
      this.snelleStats = snelleStats;
      this.vorigePositieDoel = doel;
   }

   /**
    * Method bepaalt of de wave de tegenstander heeft bereikt. Indien dit het geval is
    * wordt de hoek berekend waaronder een kogel afgevuurd had moeten worden om de tegenstander
    * te raken en wordt de corresponderende bin in de GF-statistiek opgehoogd.
    *
    * Opm. deze functie houdt geen rekening met de verplaatsing van het doel
    * tijdens de tijd sinds de laatste keer dat de golf-data is bijgewerkt.
    *
    * @return boolean waarde die aangeeft of de wave kan worden verwijdert of niet.
    */
   public boolean voorbijDoel(Point2D.Double doel, long tijd) {
      //      System.out.println("Golf.bijwerken():");
      boolean verwijderen = false;
      double  nabijheid;
      long    deltaTijd = tijd - laatsteTijd;
      double  dx = (doel.getX() - vorigePositieDoel.getX()) / deltaTijd;
      double  dy = (doel.getY() - vorigePositieDoel.getY()) / deltaTijd;

      while (laatsteTijd < tijd) {
         straal += kogelSnelheid;
         nabijheid = straal - this.distance(vorigePositieDoel);

         if (Math.abs(nabijheid) <= RAAKAFSTAND) {
//            System.out.println("Golf.bijwerken(): Golf heeft tegenstander geraakt --->");

            double exacteRichtingNaarDoel = BotUtils.bepaalRichting(this, vorigePositieDoel);
            int    hitGF = bepaalGF(exacteRichtingNaarDoel);

            double RichtingLoodrechtOpDoelRichting = exacteRichtingNaarDoel + HALFPI;
            Point2D.Double maximalePositieDoel = BotUtils.projecteerPositie(vorigePositieDoel,
                  RichtingLoodrechtOpDoelRichting, BOTGROOTTE / 2D);
            double maximaleRichtingNaarDoel = BotUtils.bepaalRichting(this, maximalePositieDoel);
            int    maxHitGF = bepaalGF(maximaleRichtingNaarDoel);
            int    delta = 1 + Math.abs(maxHitGF - hitGF);

            for (int i = 0; i < delta; i++) {
               double factor = (i == 0) ? 0.5D : 1D;
               bijwerkenHits(hitGF + i, factor / (1D + i));
               bijwerkenHits(hitGF - i, factor / (1D + i));
            }
         }

         if (nabijheid >= RAAKAFSTAND) {
            verwijderen = true;
         }

         laatsteTijd++;
         vorigePositieDoel.setLocation(vorigePositieDoel.getX() + dx, vorigePositieDoel.getY() + dy);
      }

      return verwijderen;
   }

   public int bepaalGF(double richtingNaarDoel) {
      return ((int) Math.round((Utils.normalRelativeAngle(richtingNaarDoel - richting) / (cirkelRichting*binBreedte))
               + GF_MIDDEN));
   }
   
   public void bijwerkenHits(int GF, double waarde) {
      int bin = BotUtils.maxMin(GF, 0, 2 * GF_MIDDEN);
      stats[bin] += waarde;
      snelleStats[bin] += waarde;
   }
   
   public void bijwerkenHits(double richtingNaarDoel, double waarde) {
      int GF  = bepaalGF(richtingNaarDoel);
      int bin = BotUtils.maxMin(GF, 0, 2 * GF_MIDDEN);
      stats[bin] += waarde;
      snelleStats[bin] += waarde;
   }
}
